/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.loading_utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.sun.management.OperatingSystemMXBean;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.config.ProblematicModsConfig;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.ChildProcessLogger;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.LauncherLogger;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.LibrariesJarLocator;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.IncompatibleMod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModDataParser;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ClassExistenceChecker;
import dev.kostromdan.mods.crash_assistant.common_config.utils.JavaBinaryLocator;
import dev.kostromdan.mods.crash_assistant.common_config.utils.LatestLogLocator;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JarInJarHelper {
    public static Logger LOGGER = LogManager.getLogger((String)"CrashAssistantJarInJarHelper");
    public static boolean isClient = false;

    public static void launchCrashAssistantApp(String launchTarget) {
        if (!launchTarget.toLowerCase().contains("client")) {
            LOGGER.warn("launchTarget: " + launchTarget + ". Crash Assistant is client only mod. Mod will do nothing!");
            return;
        }
        isClient = true;
        try {
            Path latestLog;
            if (CrashAssistantConfig.getBoolean("general.generate_own_launcher_log")) {
                LauncherLogger.redirectToFile();
            }
            Path originalModJarPath = Paths.get(LibrariesJarLocator.getOurModJarPath(), new String[0]).toAbsolutePath();
            LOGGER.info("Launching CrashAssistantApp ({})", new Object[]{originalModJarPath.getFileName().toString()});
            long currentProcessId = ProcessHelper.getCurrentProcessId();
            String currentProcessData = Objects.toString(currentProcessId) + "_" + Objects.toString(ProcessHelper.getCurrentProcessStartTime());
            JarInJarHelper.killAndDeleteOldApps();
            Path tempDir = Paths.get("local", "crash_assistant");
            Path tempAppJarPath = JarInJarHelper.extractJarInJar("app.jar", currentProcessData + "_app.jar");
            Path tempModJarPath = tempDir.resolve(currentProcessData + "_mod.jar");
            Files.copy(originalModJarPath, tempModJarPath, StandardCopyOption.REPLACE_EXISTING);
            String childProcess = ProcessHelper.getChildProcessesInfo();
            if (!childProcess.isEmpty()) {
                PlatformHelp.childProcessesPIDs = childProcess;
            }
            ArrayList<String> classPathEntries = new ArrayList<String>();
            classPathEntries.add(tempAppJarPath.toString());
            classPathEntries.add(tempModJarPath.toString());
            for (Class<?> clazz : ProcessHelper.getNeededForAppClasses()) {
                classPathEntries.add(LibrariesJarLocator.getLibraryJarPath(clazz));
            }
            JarInJarHelper.fixIncorrectJnaPlatform(classPathEntries);
            String fullClassPath = String.join((CharSequence)System.getProperty("path.separator"), classPathEntries);
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add("-jarPath");
            argsList.add(tempAppJarPath.toString());
            argsList.add("-parentPID");
            argsList.add(Objects.toString(ProcessHelper.getCurrentProcessId()));
            argsList.add("-parentStarted");
            argsList.add(Objects.toString(ProcessHelper.getCurrentProcessStartTime()));
            argsList.add("-platform");
            argsList.add(PlatformHelp.platform.toString());
            argsList.add("-loaderJarName");
            argsList.add(PlatformHelp.loaderJarName);
            argsList.add("-minecraftVersion");
            argsList.add(PlatformHelp.minecraftVersion);
            argsList.add("-childProcessesPIDs");
            argsList.add(Base64.getEncoder().encodeToString(PlatformHelp.childProcessesPIDs.getBytes(StandardCharsets.UTF_8)));
            argsList.add("-crashAssistantModJarName");
            argsList.add(originalModJarPath.getFileName().toString());
            argsList.add("-classPath");
            argsList.add(fullClassPath);
            argsList.add("-parentXms");
            argsList.add(JarInJarHelper.getJvmArgValue("Xms", "unknown"));
            argsList.add("-parentXmx");
            argsList.add(JarInJarHelper.getJvmArgValue("Xmx", "unknown"));
            argsList.add("-systemRAM");
            argsList.add(JarInJarHelper.formatMemorySize(JarInJarHelper.getTotalPhysicalMemory()));
            argsList.add("-processor");
            argsList.add(Base64.getEncoder().encodeToString(ProcessHelper.getProcessorName().getBytes(StandardCharsets.UTF_8)));
            if (PlatformHelp.modLoadedWithConnector) {
                argsList.add("-modLoadedWithConnector");
            }
            if (tempDir.toAbsolutePath().toString().contains("lunarclient") && (latestLog = LatestLogLocator.findLatestLogPath()) != null) {
                argsList.add("-customLatestLogPath");
                argsList.add(latestLog.toString());
            }
            Path argsFile = Paths.get("local", "crash_assistant", currentProcessData + "_args.info");
            Files.write(argsFile, argsList, StandardCharsets.UTF_8, new OpenOption[0]);
            ArrayList<String> jvmArgs = new ArrayList<String>();
            jvmArgs.add(JavaBinaryLocator.getJavaBinary());
            jvmArgs.add("-XX:+UseSerialGC");
            jvmArgs.add("-XX:MaxHeapFreeRatio=30");
            jvmArgs.add("-XX:MinHeapFreeRatio=10");
            jvmArgs.add("-XX:MaxGCPauseMillis=10000");
            jvmArgs.add("-Xms8m");
            jvmArgs.add("-Xmx512m");
            if (CrashAssistantConfig.getBoolean("general.prevent_generating_crash_assistant_app_logs")) {
                jvmArgs.add("-Dlog4j2.configurationFile=log4j2-no-logging.xml");
            }
            jvmArgs.add("-cp");
            jvmArgs.add(fullClassPath);
            jvmArgs.add("dev.kostromdan.mods.crash_assistant.app.class_loading.Boot");
            jvmArgs.add("--args-file");
            jvmArgs.add(argsFile.toString());
            ProcessBuilder crashAssistantAppProcessBuilder = new ProcessBuilder(jvmArgs);
            if ("true".equals(System.getenv("DisableEntirelyCrashAssistantModOnSystem"))) {
                LOGGER.error("Detected \"DisableEntirelyCrashAssistantModOnSystem\" env flag. Prevented start of Crash Assistant.");
                return;
            }
            Process crashAssistantAppProcess = crashAssistantAppProcessBuilder.start();
            ChildProcessLogger.captureOutput(crashAssistantAppProcess);
            ProblematicModsConfig.crashIfProblematicMod();
            JarInJarHelper.checkForIncompatibleMods(true);
        }
        catch (Throwable e) {
            LOGGER.error("Error while launching GUI: ", e);
        }
    }

    public static long getTotalPhysicalMemory() {
        try {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return osBean.getTotalPhysicalMemorySize();
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public static List<Path> getModJarPathsContainingPart(String part) {
        try {
            return Files.list(ModListUtils.MODS_FOLDER).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().toLowerCase().contains(part.toLowerCase()) && path.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
        }
        catch (Exception e) {
            return new ArrayList<Path>();
        }
    }

    public static List<Mod> mapPathsToMods(List<Path> paths) {
        return paths.stream().map(ModDataParser::parseModData).collect(Collectors.toList());
    }

    public static List<Mod> getModsContainingPart(String ... parts) {
        HashSet<Mod> resultSet = new HashSet<Mod>();
        for (String part : parts) {
            resultSet.addAll(JarInJarHelper.mapPathsToMods(JarInJarHelper.getModJarPathsContainingPart(part)));
        }
        return new ArrayList<Mod>(resultSet);
    }

    public static boolean isCleanroomRelauncher() {
        HashSet<String> relauncherModIds = new HashSet<String>(Arrays.asList("cleanroom-relauncher", "improved-relauncher", "relauncher"));
        List<Mod> mods = JarInJarHelper.getModsContainingPart("cleanroom", "relauncher");
        if ((mods = mods.stream().filter(mod -> relauncherModIds.contains(mod.getModId())).collect(Collectors.toList())).isEmpty()) {
            return false;
        }
        if (!ClassExistenceChecker.classExists("com.cleanroommc.boot.Main")) {
            LOGGER.warn("Detected cleanroom-relauncher env. Crash Assistant will start after relaunching with cleanroom.");
            return true;
        }
        return false;
    }

    public static Optional<Long> getCleanroomRelauncherParentPid() {
        String pid = System.getProperty("cleanroom.relauncher.parent");
        if (pid == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Long.parseLong(pid));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static List<Mod> checkDuplicatedCrashAssistantMod(boolean crashIfDuplicated) {
        try {
            List<Mod> mods = JarInJarHelper.getModsContainingPart("crash_assistant-", "CrashAssistant-");
            if (mods.size() < 2) {
                return new ArrayList<Mod>();
            }
            List modsWithSameModId = mods.stream().filter(mod -> Objects.equals(mod.getModId(), "crash_assistant")).collect(Collectors.toList());
            String duplicatedMods = String.join((CharSequence)"\n", mods.stream().map(Mod::getJarName).collect(Collectors.toList()));
            if (modsWithSameModId.size() > 1) {
                LOGGER.error("Found more than one mod with modid \"crash_assistant\". Crash Assistant is duplicated." + (crashIfDuplicated ? " Crashing!" : "") + "\nDuplicated mods:\n" + duplicatedMods);
                if (crashIfDuplicated) {
                    ProcessHelper.exitProcess(-1);
                }
            } else {
                LOGGER.error("Found more than one mod starting with \"crash_assistant-\":\n" + duplicatedMods + "\nAssuming Crash Assistant is duplicated. Duplicated coremods can produce wired issues.");
            }
            return mods;
        }
        catch (Exception e) {
            LOGGER.error("Error while checking duplicated mods", (Throwable)e);
            return new ArrayList<Mod>();
        }
    }

    public static Optional<IncompatibleMod> checkForIncompatibleMods(boolean crashIfIncompatibleModDetected) {
        if (!isClient && crashIfIncompatibleModDetected) {
            return Optional.empty();
        }
        for (IncompatibleMod incompatibleMod : IncompatibleMod.incompatibleMods) {
            List<Mod> mods;
            List<Path> modPaths = JarInJarHelper.getModJarPathsContainingPart(incompatibleMod.getJarNamePart());
            if (modPaths.isEmpty() || (mods = JarInJarHelper.mapPathsToMods(modPaths).stream().filter(mod -> Objects.equals(mod.getModId(), incompatibleMod.getModId())).collect(Collectors.toList())).isEmpty()) continue;
            incompatibleMod.addDetectedMods(mods);
            if (crashIfIncompatibleModDetected) {
                String incompatibleModsString = String.join((CharSequence)", ", mods.stream().map(Mod::getJarName).collect(Collectors.toList()));
                String crashAssistantString = "Crash Assistant";
                try {
                    crashAssistantString = Paths.get(LibrariesJarLocator.getOurModJarPath(), new String[0]).getFileName().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String incompatibleMessage = crashAssistantString + " and " + incompatibleModsString + " are incompatible.";
                if (CrashAssistantConfig.getBoolean("compatibility.enabled")) {
                    LOGGER.error("Crash Assistant detected incompatible mod(s), crashing to prevent potential issues:\n{}", new Object[]{incompatibleMessage + " Remove one of them."});
                    ProcessHelper.exitProcess(-1);
                } else {
                    LOGGER.warn("Crash Assistant detected incompatible mod(s). Compatibility check is disabled! Issues may arise!\n{}", new Object[]{incompatibleMessage + " Continue at your own risk!"});
                }
            }
            return Optional.of(incompatibleMod);
        }
        return Optional.empty();
    }

    public static Path extractJarInJar(String embeddedName, String outputName) throws IOException {
        Path outputDirectory = Paths.get("local", "crash_assistant");
        if (!Files.exists(outputDirectory, new LinkOption[0])) {
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
        }
        Path extractedJarPath = outputDirectory.resolve(outputName);
        JarInJarHelper.unzipFromJar("/META-INF/jarjar/" + embeddedName, extractedJarPath);
        return extractedJarPath;
    }

    public static void killAndDeleteOldApps() throws IOException {
        Path outputDirectory = Paths.get("local", "crash_assistant");
        if (!Files.exists(outputDirectory, new LinkOption[0])) {
            return;
        }
        Files.list(outputDirectory).forEach(path -> {
            String processInfo;
            String fileName = path.getFileName().toString();
            if (Files.isRegularFile(path, new LinkOption[0]) && fileName.endsWith("app.jar")) {
                Path oldDllPath;
                Path oldCSPath;
                Path argsInfoPath;
                Path processInfoPath;
                Path tmpModLibJarPath;
                block19: {
                    String processInfo2 = fileName.split("_app.jar")[0];
                    tmpModLibJarPath = outputDirectory.resolve(processInfo2 + "_mod.jar");
                    processInfoPath = outputDirectory.resolve(processInfo2 + ".info");
                    argsInfoPath = outputDirectory.resolve(processInfo2 + "_args.info");
                    oldCSPath = outputDirectory.resolve(processInfo2 + "_gpu_detect.cs");
                    oldDllPath = outputDirectory.resolve(processInfo2 + "_gpu-detect-jni.dll");
                    try {
                        Long app_pid;
                        if (!Files.exists(processInfoPath, new LinkOption[0]) || !CrashAssistantConfig.getBoolean("general.kill_old_app")) break block19;
                        Long minecraft_pid = Long.parseLong(processInfo2.split("_")[0]);
                        Long start_time = Long.parseLong(processInfo2.split("_")[1]);
                        Long app_start_time = null;
                        try {
                            byte[] bytes = Files.readAllBytes(processInfoPath);
                            String content = new String(bytes, StandardCharsets.UTF_8);
                            if (content.contains(" : ")) {
                                app_pid = Long.parseLong(content.split(" : ")[0].trim());
                                app_start_time = Long.parseLong(content.split(" : ")[1].trim());
                            } else {
                                app_pid = Long.parseLong(content);
                            }
                        }
                        catch (IOException ex) {
                            LOGGER.error("Error while reading " + processInfoPath + ". This should never happen:", (Throwable)ex);
                            throw new RuntimeException(ex);
                        }
                        boolean isAppProcessAlive = ProcessHelper.isProcessAlive(app_pid);
                        long minecraftStartTime = ProcessHelper.getProcessStartTime(minecraft_pid);
                        if (isAppProcessAlive && (app_start_time == null || app_start_time == ProcessHelper.getProcessStartTime(app_pid))) {
                            Optional<Long> cleanroomRelauncherParentPid;
                            boolean oldMinecraftIsAlive = ProcessHelper.isProcessAlive(minecraft_pid) && minecraftStartTime == start_time;
                            boolean isOldPidIsRelauncher = false;
                            if (Objects.equals(PlatformHelp.minecraftVersion, "1.12.2") && (cleanroomRelauncherParentPid = JarInJarHelper.getCleanroomRelauncherParentPid()).isPresent()) {
                                isOldPidIsRelauncher = minecraft_pid.equals(cleanroomRelauncherParentPid.get());
                            }
                            if (oldMinecraftIsAlive && isOldPidIsRelauncher) {
                                LOGGER.warn("Closed old CrashAssistantApp process since relaunch with Cleanroom happened.");
                            } else if (!oldMinecraftIsAlive) {
                                LOGGER.warn("Closed old CrashAssistantApp process to prevent confusing the player with window containing information from old crash.");
                            }
                            if (!oldMinecraftIsAlive || isOldPidIsRelauncher) {
                                ProcessHelper.destroyProcess(app_pid);
                                new Timer().schedule(new TimerTask((Path)path, tmpModLibJarPath, processInfoPath, argsInfoPath, oldCSPath, oldDllPath){
                                    final /* synthetic */ Path val$path;
                                    final /* synthetic */ Path val$tmpModLibJarPath;
                                    final /* synthetic */ Path val$processInfoPath;
                                    final /* synthetic */ Path val$argsInfoPath;
                                    final /* synthetic */ Path val$oldCSPath;
                                    final /* synthetic */ Path val$oldDllPath;
                                    {
                                        this.val$path = path;
                                        this.val$tmpModLibJarPath = path2;
                                        this.val$processInfoPath = path3;
                                        this.val$argsInfoPath = path4;
                                        this.val$oldCSPath = path5;
                                        this.val$oldDllPath = path6;
                                    }

                                    @Override
                                    public void run() {
                                        try {
                                            Files.deleteIfExists(this.val$path);
                                            Files.deleteIfExists(this.val$tmpModLibJarPath);
                                            Files.deleteIfExists(this.val$processInfoPath);
                                            Files.deleteIfExists(this.val$argsInfoPath);
                                            Files.deleteIfExists(this.val$oldCSPath);
                                            Files.deleteIfExists(this.val$oldDllPath);
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                }, 5000L);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error while removing '{}' or reading '{}'. This should never happen. Maybe files got corrupted?", new Object[]{fileName, processInfoPath.getFileName(), e});
                    }
                }
                try {
                    Files.deleteIfExists(path);
                    Files.deleteIfExists(tmpModLibJarPath);
                    Files.deleteIfExists(processInfoPath);
                    Files.deleteIfExists(argsInfoPath);
                    Files.deleteIfExists(oldCSPath);
                    Files.deleteIfExists(oldDllPath);
                }
                catch (IOException iOException) {}
            } else if (Files.isRegularFile(path, new LinkOption[0]) && (fileName.endsWith(".info") || fileName.endsWith("_mod.jar") || fileName.endsWith("_gpu_detect.cs") || fileName.endsWith("_gpu-detect-jni.dll")) && fileName.contains("_") && !Files.exists(outputDirectory.resolve((processInfo = fileName.endsWith("_args.info") ? fileName.split("_args\\.info")[0] : (fileName.endsWith(".info") ? fileName.split("\\.info")[0] : (fileName.endsWith(".cs") ? fileName.split("_gpu_detect\\.cs")[0] : (fileName.endsWith(".dll") ? fileName.split("_gpu-detect-jni\\.dll")[0] : fileName.split("_mod\\.jar")[0])))) + "_app.jar"), new LinkOption[0])) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public static void unzipFromJar(String embeddedPath, Path extractedPath) {
        if (!embeddedPath.startsWith("/")) {
            embeddedPath = "/" + embeddedPath;
        }
        try {
            InputStream jarStream = JarInJarHelper.class.getResourceAsStream(embeddedPath);
            if (jarStream == null) {
                throw new FileNotFoundException("Could not find embedded JAR: " + embeddedPath);
            }
            try (OutputStream out = Files.newOutputStream(extractedPath, new OpenOption[0]);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = jarStream.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to unzip file from jar " + embeddedPath, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public static HashMap<String, String> readJsonFromJar(String embeddedPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap<String, String> readJsonFromFile(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            HashMap<String, String> throwable3 = JarInJarHelper.convertJsonToMap(new JsonParser().parse((Reader)reader).getAsJsonObject());
            return throwable3;
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Failed to read corrupted json from file '{}'. Renaming to .bak", new Object[]{path, e});
            String fileName = path.getFileName().toString();
            try {
                path.toFile().renameTo(Paths.get(path.getParent().toString(), fileName + ".bak").toFile());
                return new HashMap<String, String>();
            }
            catch (Exception e1) {
                LOGGER.error("Failed to rename '" + fileName + "' to '" + fileName + ".bak': ", (Throwable)e1);
                return new HashMap<String, String>();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to read json from file " + path.toString(), (Throwable)e);
        }
        return new HashMap<String, String>();
    }

    public static void writeJsonToFile(Map<String, String> json, Path path) {
        try (FileWriter writer = new FileWriter(path.toFile());){
            Gson GSON = new GsonBuilder().setPrettyPrinting().create();
            GSON.toJson(json, (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving json " + path, (Throwable)e);
        }
    }

    public static HashMap<String, String> convertJsonToMap(JsonObject json) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (Map.Entry entry : json.entrySet()) {
            values.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
        return values;
    }

    public static Path getJarInJar(String name) throws IOException, URISyntaxException {
        Path pathInModFile = Paths.get(JarInJarHelper.class.getProtectionDomain().getCodeSource().getLocation().toURI()).resolve("META-INF/jarjar/" + name);
        URI filePathUri = new URI("jij:" + pathInModFile.toAbsolutePath().toUri().getRawSchemeSpecificPart()).normalize();
        Map<String, Path> outerFsArgs = Collections.singletonMap("packagePath", pathInModFile);
        FileSystem zipFS = FileSystems.newFileSystem(filePathUri, outerFsArgs);
        return zipFS.getPath("/", new String[0]);
    }

    public static String getJvmArgValue(String argName, String fallback) {
        try {
            List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : inputArgs) {
                if (!arg.startsWith("-" + argName)) continue;
                if (arg.length() > argName.length() + 1) {
                    return arg.substring(argName.length() + 1);
                }
                return arg.substring(1);
            }
            if (argName.equals("Xmx") && fallback.equals("unknown")) {
                return JarInJarHelper.formatMemorySize(Runtime.getRuntime().maxMemory());
            }
            return fallback;
        }
        catch (Exception e) {
            LOGGER.error("Error retrieving JVM argument {}: {}", new Object[]{argName, e.getMessage()});
            return fallback;
        }
    }

    private static String formatMemorySize(long bytes) {
        if (bytes >= 0x40000000L) {
            double gb = (double)bytes / 1.073741824E9;
            String formatted = String.format(Locale.US, "%.1f", gb).replace(".0", "");
            return formatted + "g";
        }
        double mb = (double)bytes / 1048576.0;
        String formatted = String.format(Locale.US, "%.1f", mb).replace(".0", "");
        return formatted + "m";
    }

    private static void fixIncorrectJnaPlatform(List<String> classPathEntries) {
        if (classPathEntries == null || classPathEntries.size() < 2) {
            return;
        }
        int firstIndex = -1;
        int secondIndex = -1;
        block0: for (int i = 0; i < classPathEntries.size(); ++i) {
            String entryI = classPathEntries.get(i);
            File fileI = new File(entryI);
            String fileNameI = fileI.getName();
            if (!fileNameI.startsWith("jna-") || fileNameI.startsWith("jna-platform-") || !fileNameI.endsWith(".jar")) continue;
            for (int j = i + 1; j < classPathEntries.size(); ++j) {
                if (!entryI.equals(classPathEntries.get(j))) continue;
                firstIndex = i;
                secondIndex = j;
                break block0;
            }
        }
        if (firstIndex == -1) {
            return;
        }
        String original = classPathEntries.get(firstIndex);
        File jnaJarFile = new File(original);
        String fileName = jnaJarFile.getName();
        if (!fileName.startsWith("jna-") || !fileName.endsWith(".jar")) {
            return;
        }
        String baseName = fileName.substring(0, fileName.length() - ".jar".length());
        String version = baseName.substring("jna-".length());
        File versionDir = jnaJarFile.getParentFile();
        if (versionDir == null) {
            return;
        }
        File jnaDir = versionDir.getParentFile();
        if (jnaDir == null) {
            return;
        }
        File jnaRoot = jnaDir.getParentFile();
        if (jnaRoot == null) {
            return;
        }
        File jnaPlatformDir = new File(new File(jnaRoot, "jna-platform"), version);
        File jnaPlatformJarFile = new File(jnaPlatformDir, "jna-platform-" + version + ".jar");
        if (!jnaPlatformJarFile.isFile()) {
            return;
        }
        classPathEntries.set(firstIndex, original);
        classPathEntries.set(secondIndex, jnaPlatformJarFile.getAbsolutePath());
    }
}

