/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.platform;

import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelper;
import dev.kostromdan.mods.crash_assistant.common_config.utils.maven_version_cmp.VersionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public enum PlatformHelp {
    NEOFORGE("https://discord.neoforged.net", "NeoForge Discord", "#user_support channel"),
    FABRIC("https://discord.gg/v6v4pMv", "Fabric Discord", "#player-support channel"),
    QUILT("https://discord.quiltmc.org/", "QuiltMC Discord", "#player-support channel"),
    UNKNOWN("https://discord.gg/moddedmc", "ModdedMC Discord", "#player-help channel"),
    CLEANROOM("https://discord.gg/sgQxDJdrnY", "Cleanroom Discord", "#lobby channel"),
    LEGACY_MODDING("https://discord.com/invite/AJxEFs6YBN", "Legacy Modding Discord", "#modding-help forums"),
    FORGE(LEGACY_MODDING);

    private final String helpLink;
    private final String helpName;
    private final String helpChannel;
    public static PlatformHelp platform;
    public static boolean modLoadedWithConnector;
    public static String loaderJarName;
    public static String minecraftVersion;
    public static final String OS;
    public static final String javaVersion;
    public static String childProcessesPIDs;

    private PlatformHelp(String helpLink, String helpName, String helpChannel) {
        this.helpLink = helpLink;
        this.helpName = helpName;
        this.helpChannel = helpChannel;
    }

    private PlatformHelp(PlatformHelp fromPlatform) {
        this.helpLink = fromPlatform.helpLink;
        this.helpName = fromPlatform.helpName;
        this.helpChannel = fromPlatform.helpChannel;
    }

    public static boolean isLinkDefault() {
        return Objects.equals(CrashAssistantConfig.get("general.help_link"), "CHANGE_ME");
    }

    public static String getActualHelpLink() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("general.help_link");
        }
        return PlatformHelp.platform.helpLink;
    }

    public static String getActualHelpName() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("text.support_name");
        }
        return PlatformHelp.platform.helpName;
    }

    public static String getActualHelpChannel() {
        if (!PlatformHelp.isLinkDefault()) {
            return (String)CrashAssistantConfig.get("text.support_place");
        }
        return PlatformHelp.platform.helpChannel;
    }

    public static List<String> getOrderedInJarPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        switch (platform) {
            case NEOFORGE: {
                paths.add("META-INF/neoforge.mods.toml");
                paths.add("META-INF/mods.toml");
                paths.add("fabric.mod.json");
                break;
            }
            case FABRIC: 
            case QUILT: {
                paths.add("fabric.mod.json");
                paths.add("META-INF/mods.toml");
                paths.add("META-INF/neoforge.mods.toml");
                break;
            }
            case FORGE: {
                if (VersionUtils.isLowerThanOrEqual(minecraftVersion, "1.12.2")) {
                    paths.add("mcmod.info");
                }
                paths.add("META-INF/mods.toml");
                paths.add("META-INF/neoforge.mods.toml");
                paths.add("fabric.mod.json");
                break;
            }
            default: {
                paths.add("META-INF/mods.toml");
                paths.add("META-INF/neoforge.mods.toml");
                paths.add("fabric.mod.json");
                paths.add("mcmod.info");
            }
        }
        return paths;
    }

    public static boolean isLinux() {
        return OS.contains("nux");
    }

    public static boolean isMacOS() {
        return OS.contains("mac");
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isFabricBased() {
        return platform == FABRIC || platform == QUILT;
    }

    public static boolean isForgeBased() {
        return platform == FORGE || platform == NEOFORGE;
    }

    public static int parseJdkMajorVersion(String jdepsVersionOutput) {
        String[] parts;
        if (jdepsVersionOutput == null || jdepsVersionOutput.trim().isEmpty()) {
            return -1;
        }
        String version = jdepsVersionOutput.trim();
        if (version.startsWith("1.") && (parts = version.split("\\.")).length >= 2) {
            try {
                return Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        StringBuilder majorVersionStr = new StringBuilder();
        for (char c : version.toCharArray()) {
            if (Character.isDigit(c)) {
                majorVersionStr.append(c);
                continue;
            }
            if (c == '.' || c == '-' || c == '+' || majorVersionStr.length() != 0) break;
        }
        if (majorVersionStr.length() > 0) {
            try {
                return Integer.parseInt(majorVersionStr.toString());
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public static int getCurrentJdkMajorVersion() {
        return PlatformHelp.parseJdkMajorVersion(javaVersion);
    }

    public static boolean isJdkVersionSufficient(String jdepsVersionOutput) {
        int parsedMajorVersion = PlatformHelp.parseJdkMajorVersion(jdepsVersionOutput);
        int currentMajorVersion = PlatformHelp.getCurrentJdkMajorVersion();
        if (parsedMajorVersion == -1 || currentMajorVersion == -1) {
            return true;
        }
        return parsedMajorVersion >= currentMajorVersion;
    }

    static {
        platform = UNKNOWN;
        modLoadedWithConnector = false;
        loaderJarName = "UNDEFINED";
        minecraftVersion = "UNDEFINED";
        OS = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        javaVersion = ProcessHelper.getJavaVersion();
        childProcessesPIDs = "UNDEFINED";
    }
}

