/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.utils;

import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHandleUnixAbstractImpl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;

public class ProcessHandleMacOSImpl
extends ProcessHandleUnixAbstractImpl {
    private static final DateTimeFormatter PS_LSTART = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss yyyy", Locale.ENGLISH);
    private static final ZoneId LOCAL_ZONE = ZoneId.systemDefault();

    @Override
    public Optional<String> getCurrentProcessCommand() {
        return this.getExecutablePath(this.getCurrentProcessId());
    }

    @Override
    public long getCurrentProcessStartTime() {
        return this.getProcessStartTime(this.getCurrentProcessId());
    }

    @Override
    public long getProcessStartTime(long pid) {
        try {
            if (!this.isProcessAlive(pid)) {
                return -1L;
            }
            String lstart = ProcessHandleMacOSImpl.execAndReadFirst("ps", "-p", String.valueOf(pid), "-o", "lstart=");
            if (lstart == null || lstart.trim().isEmpty()) {
                return 0L;
            }
            LocalDateTime ldt = LocalDateTime.parse(lstart.trim(), PS_LSTART);
            return ldt.atZone(LOCAL_ZONE).toInstant().toEpochMilli();
        }
        catch (Throwable ignored) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> getExecutablePath(long pid) {
        try {
            Process p = new ProcessBuilder("lsof", "-p", String.valueOf(pid), "-a", "-d", "txt", "-Fn").redirectErrorStream(true).start();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("n") || line.length() <= 1) continue;
                    Optional<String> optional = Optional.of(line.substring(1));
                    return optional;
                }
            }
            finally {
                p.destroy();
            }
        }
        catch (Throwable p) {
            // empty catch block
        }
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) return Optional.empty();
        if (javaHome.isEmpty()) return Optional.empty();
        Path cmd = Paths.get(javaHome, "bin", "java");
        if (!Files.isExecutable(cmd)) return Optional.empty();
        return Optional.of(cmd.toString());
    }
}

