/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.mod_list;

import dev.kostromdan.mods.crash_assistant.common_config.communication.ProcessSignalIO;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModDataParser;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.PathComparator;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModListUtils {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Path MODS_FOLDER = Paths.get("mods", new String[0]);
    private static final Path RESOURCEPACKS_FOLDER = Paths.get("resourcepacks", new String[0]);
    private static final Path JSON_FILE = Paths.get("config", "crash_assistant", "modlist.json");
    public static String currentUsername = "";
    private static LinkedHashSet<Mod> cachedModList = null;

    public static synchronized LinkedHashSet<Mod> getCurrentModList(boolean useCache) {
        if (cachedModList != null && useCache) {
            return cachedModList;
        }
        try {
            LinkedHashSet<Mod> currentMods = new LinkedHashSet<Mod>();
            if (CrashAssistantConfig.getBoolean("modpack_modlist.add_modloader_jar_name")) {
                currentMods.add(new Mod(PlatformHelp.loaderJarName + " (modloader)", PlatformHelp.platform.name().toLowerCase(), PlatformHelp.loaderJarName, null, new HashSet<String>(), new ArrayList<Mod>(), null));
            }
            if (Files.exists(MODS_FOLDER, new LinkOption[0])) {
                long start = System.currentTimeMillis();
                ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                ArrayList futures = new ArrayList();
                Files.list(MODS_FOLDER).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar")).sorted(new PathComparator()).forEach(path -> futures.add(executor.submit(() -> ModDataParser.parseModData(path))));
                for (Future future : futures) {
                    currentMods.add((Mod)future.get());
                }
                executor.shutdown();
                LOGGER.info("Parsed " + currentMods.size() + " mod(s) metadata in " + (System.currentTimeMillis() - start) + " ms");
            }
            if (Files.exists(RESOURCEPACKS_FOLDER, new LinkOption[0]) && CrashAssistantConfig.getBoolean("modpack_modlist.add_resourcepacks")) {
                Files.list(RESOURCEPACKS_FOLDER).sorted(new PathComparator()).forEach(path -> {
                    String filename = path.getFileName().toString();
                    if (Files.isDirectory(path, new LinkOption[0]) || filename.endsWith(".zip")) {
                        currentMods.add(new Mod(filename + " (resourcepack)", null, null, null, new HashSet<String>(), new ArrayList<Mod>(), null));
                    }
                });
            }
            if (useCache) {
                cachedModList = currentMods;
            }
            return currentMods;
        }
        catch (Exception e) {
            LOGGER.error("Error while getting current mod list: ", (Throwable)e);
            return new LinkedHashSet<Mod>();
        }
    }

    public static LinkedHashSet<Mod> getSavedModList() {
        try {
            if (Files.exists(JSON_FILE, new LinkOption[0])) {
                String json = new String(Files.readAllBytes(JSON_FILE));
                return (LinkedHashSet)Mod.GSON.fromJson(json, Mod.TYPE);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while getting Modlist", (Throwable)e);
        }
        return new LinkedHashSet<Mod>();
    }

    public static void saveCurrentModList() {
        try {
            try (FileWriter writer = new FileWriter(JSON_FILE.toFile());){
                String jsonOutput = Mod.GSON.toJson(ModListUtils.getCurrentModList(false), Mod.TYPE);
                writer.write(jsonOutput);
            }
            LOGGER.info("Modlist saved to " + String.valueOf(JSON_FILE));
        }
        catch (Exception e) {
            LOGGER.error("Error while saving Modlist", (Throwable)e);
        }
    }

    public static String getCurrentUsername() {
        if (currentUsername.isEmpty()) {
            Optional<String> x = ProcessSignalIO.getInfo("username");
            x.ifPresent(s -> {
                currentUsername = s;
            });
        }
        return currentUsername;
    }
}

