/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs;

import com.mojang.brigadier.CommandDispatcher;
import com.smartmobs.ai.CreeperNapalmGoal;
import com.smartmobs.ai.CreeperOmniscienceGoal;
import com.smartmobs.ai.CreeperPrePoweredGoal;
import com.smartmobs.ai.CreeperWallExplosionGoal;
import com.smartmobs.ai.EndermanSlenderEffectsGoal;
import com.smartmobs.ai.EndermanTeleportPlayerGoal;
import com.smartmobs.ai.SkeletonSniperGoal;
import com.smartmobs.ai.SpiderWebAttackGoal;
import com.smartmobs.ai.SpiderWebGoal;
import com.smartmobs.ai.ZombieAutoFloorGoal;
import com.smartmobs.ai.ZombieBreakBlockGoal;
import com.smartmobs.ai.ZombieBridgeGoal;
import com.smartmobs.ai.ZombieOmniscienceGoal;
import com.smartmobs.ai.ZombiePillarGoal;
import com.smartmobs.commands.SmartMobsCommand;
import com.smartmobs.config.SmartMobsConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="smartmobs")
public class SmartMobsMod {
    private static final Logger LOGGER = LogManager.getLogger();

    public SmartMobsMod() {
        LOGGER.info("Smart Mobs mod is initializing...");
        SmartMobsConfig.register();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onCommonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Smart Mobs mod setup complete!");
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            LOGGER.debug("Adding smart AI to zombie: {}", (Object)zombie.m_5446_().getString());
            if (((Boolean)SmartMobsConfig.ZOMBIE_OMNISCIENCE.get()).booleanValue()) {
                zombie.f_21346_.m_25352_(1, (Goal)new ZombieOmniscienceGoal(zombie, (Double)SmartMobsConfig.ZOMBIE_OMNISCIENCE_RANGE.get()));
            }
            if (((Boolean)SmartMobsConfig.ZOMBIE_BLOCK_BREAKING.get()).booleanValue()) {
                zombie.f_21345_.m_25352_(1, (Goal)new ZombieBreakBlockGoal(zombie));
            }
            zombie.f_21345_.m_25352_(2, (Goal)new ZombieAutoFloorGoal(zombie));
            if (((Boolean)SmartMobsConfig.ZOMBIE_PILLAR_BUILDING.get()).booleanValue()) {
                zombie.f_21345_.m_25352_(4, (Goal)new ZombiePillarGoal(zombie));
            }
            if (((Boolean)SmartMobsConfig.ZOMBIE_BRIDGE_BUILDING.get()).booleanValue()) {
                zombie.f_21345_.m_25352_(5, (Goal)new ZombieBridgeGoal(zombie));
            }
        } else {
            entity = event.getEntity();
            if (entity instanceof AbstractSkeleton) {
                AbstractSkeleton skeleton = (AbstractSkeleton)entity;
                LOGGER.debug("Adding sniper AI to skeleton: {}", (Object)skeleton.m_5446_().getString());
                if (((Boolean)SmartMobsConfig.SKELETON_SNIPER_AI.get()).booleanValue()) {
                    skeleton.f_21345_.m_25352_(1, (Goal)new SkeletonSniperGoal(skeleton));
                }
            } else {
                entity = event.getEntity();
                if (entity instanceof Spider) {
                    Spider spider = (Spider)entity;
                    LOGGER.debug("Adding web AI to spider: {}", (Object)spider.m_5446_().getString());
                    if (((Boolean)SmartMobsConfig.SPIDER_WEB_ATTACKS.get()).booleanValue()) {
                        spider.f_21345_.m_25352_(2, (Goal)new SpiderWebAttackGoal(spider));
                        spider.f_21345_.m_25352_(3, (Goal)new SpiderWebGoal(spider));
                    }
                } else {
                    entity = event.getEntity();
                    if (entity instanceof Creeper) {
                        Creeper creeper = (Creeper)entity;
                        LOGGER.debug("Adding smart AI to creeper: {}", (Object)creeper.m_5446_().getString());
                        if (((Boolean)SmartMobsConfig.CREEPER_OMNISCIENCE.get()).booleanValue()) {
                            creeper.f_21346_.m_25352_(1, (Goal)new CreeperOmniscienceGoal(creeper, (Double)SmartMobsConfig.CREEPER_OMNISCIENCE_RANGE.get()));
                        }
                        if (((Boolean)SmartMobsConfig.CREEPER_PRE_POWERED.get()).booleanValue()) {
                            creeper.f_21345_.m_25352_(1, (Goal)new CreeperPrePoweredGoal(creeper));
                        }
                        if (((Boolean)SmartMobsConfig.CREEPER_WALL_EXPLOSION.get()).booleanValue()) {
                            creeper.f_21345_.m_25352_(2, (Goal)new CreeperWallExplosionGoal(creeper));
                        }
                        if (((Boolean)SmartMobsConfig.CREEPER_NAPALM_EXPLOSION.get()).booleanValue()) {
                            creeper.f_21345_.m_25352_(3, (Goal)new CreeperNapalmGoal(creeper));
                        }
                    } else {
                        entity = event.getEntity();
                        if (entity instanceof EnderMan) {
                            EnderMan enderman = (EnderMan)entity;
                            LOGGER.debug("Adding smart AI to enderman: {}", (Object)enderman.m_5446_().getString());
                            if (((Boolean)SmartMobsConfig.ENDERMAN_TELEPORT_PLAYER.get()).booleanValue()) {
                                enderman.f_21345_.m_25352_(1, (Goal)new EndermanTeleportPlayerGoal(enderman));
                            }
                            if (((Boolean)SmartMobsConfig.ENDERMAN_SLENDER_EFFECTS.get()).booleanValue()) {
                                enderman.f_21345_.m_25352_(2, (Goal)new EndermanSlenderEffectsGoal(enderman));
                            }
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        SmartMobsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        LOGGER.info("Registered Smart Mobs commands");
    }
}

