/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreeperBreachGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Creeper creeper;
    private BlockPos targetBlockPos;
    private int breakingTime;
    private int maxBreakingTime;
    private float breakProgress;
    private Path path;
    private int reachCheckCounter;

    public CreeperBreachGoal(Creeper creeper) {
        this.creeper = creeper;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.creeper.m_5448_() == null || !this.creeper.m_5448_().m_6084_()) {
            return false;
        }
        PathNavigation navigation = this.creeper.m_21573_();
        Path pathToTarget = navigation.m_6570_((Entity)this.creeper.m_5448_(), 0);
        if (pathToTarget != null && pathToTarget.m_77403_()) {
            return false;
        }
        BlockPos blockToBreak = this.findBlockingBlock();
        if (blockToBreak != null) {
            this.targetBlockPos = blockToBreak;
            this.breakingTime = 0;
            this.maxBreakingTime = this.getBreakingTime(blockToBreak);
            this.breakProgress = 0.0f;
            this.path = navigation.m_7864_(blockToBreak, 0);
            this.reachCheckCounter = 0;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.creeper.m_5448_() == null || !this.creeper.m_5448_().m_6084_()) {
            return false;
        }
        if (this.targetBlockPos == null) {
            return false;
        }
        Level level = this.creeper.m_9236_();
        BlockState blockState = level.m_8055_(this.targetBlockPos);
        if (blockState.m_60795_() || blockState.m_60734_() == Blocks.f_50016_) {
            return false;
        }
        ++this.reachCheckCounter;
        if (this.reachCheckCounter > 20) {
            PathNavigation navigation = this.creeper.m_21573_();
            Path pathToTarget = navigation.m_6570_((Entity)this.creeper.m_5448_(), 0);
            if (pathToTarget != null && pathToTarget.m_77403_()) {
                return false;
            }
            this.reachCheckCounter = 0;
        }
        return true;
    }

    public void m_8056_() {
        LOGGER.debug("Creeper {} starting to breach block at {}", (Object)this.creeper.m_5446_().getString(), (Object)this.targetBlockPos);
    }

    public void m_8041_() {
        this.targetBlockPos = null;
        this.breakingTime = 0;
        this.breakProgress = 0.0f;
        this.path = null;
        this.creeper.m_21573_().m_26573_();
        Level level = this.creeper.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.targetBlockPos != null) {
                serverLevel.m_6801_(this.creeper.m_19879_(), this.targetBlockPos, -1);
            }
        }
    }

    public void m_8037_() {
        ServerLevel serverLevel;
        if (this.targetBlockPos == null) {
            return;
        }
        Level level = this.creeper.m_9236_();
        BlockState blockState = level.m_8055_(this.targetBlockPos);
        if (blockState.m_60795_() || blockState.m_60734_() == Blocks.f_50016_) {
            this.m_8041_();
            return;
        }
        double distance = this.creeper.m_20238_(Vec3.m_82512_((Vec3i)this.targetBlockPos));
        if (distance > 4.0) {
            if (this.path != null) {
                this.creeper.m_21573_().m_26536_(this.path, 1.0);
            }
            return;
        }
        this.creeper.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)this.targetBlockPos));
        ++this.breakingTime;
        this.breakProgress = (float)this.breakingTime / (float)this.maxBreakingTime;
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            int progressStage = (int)(this.breakProgress * 10.0f);
            serverLevel.m_6801_(this.creeper.m_19879_(), this.targetBlockPos, progressStage);
        }
        if (this.breakingTime % 10 == 0) {
            level.m_5594_(null, this.targetBlockPos, SoundEvents.f_12599_, SoundSource.HOSTILE, 0.5f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        }
        if (this.breakingTime % 5 == 0 && level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            Vec3 blockCenter = Vec3.m_82512_((Vec3i)this.targetBlockPos);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, blockCenter.f_82479_, blockCenter.f_82480_, blockCenter.f_82481_, 5, 0.3, 0.3, 0.3, 0.1);
        }
        if (this.breakProgress >= 1.0f) {
            level.m_46961_(this.targetBlockPos, true);
            level.m_5594_(null, this.targetBlockPos, SoundEvents.f_12601_, SoundSource.HOSTILE, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                Vec3 blockCenter = Vec3.m_82512_((Vec3i)this.targetBlockPos);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, blockCenter.f_82479_, blockCenter.f_82480_, blockCenter.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.m_8041_();
        }
    }

    private BlockPos findBlockingBlock() {
        if (this.creeper.m_5448_() == null) {
            return null;
        }
        Vec3 creeperPos = this.creeper.m_20182_();
        Vec3 targetPos = this.creeper.m_5448_().m_20182_();
        Vec3 direction = targetPos.m_82546_(creeperPos).m_82541_();
        for (int i = 1; i <= 10; ++i) {
            Vec3 checkPos = creeperPos.m_82549_(direction.m_82490_((double)i));
            BlockPos blockPos = new BlockPos((int)checkPos.f_82479_, (int)checkPos.f_82480_, (int)checkPos.f_82481_);
            Level level = this.creeper.m_9236_();
            BlockState blockState = level.m_8055_(blockPos);
            if (!this.canBreakBlock(blockState, blockPos) || !this.isBlockBlockingPath(blockPos)) continue;
            return blockPos;
        }
        return null;
    }

    private boolean canBreakBlock(BlockState blockState, BlockPos pos) {
        if (blockState.m_60795_()) {
            return false;
        }
        Block block = blockState.m_60734_();
        if (block == Blocks.f_50752_ || block == Blocks.f_50375_ || block == Blocks.f_50272_ || block == Blocks.f_50448_ || block == Blocks.f_50447_ || block == Blocks.f_50677_) {
            return false;
        }
        float destroySpeed = blockState.m_60800_((BlockGetter)this.creeper.m_9236_(), pos);
        if (destroySpeed < 0.0f) {
            return false;
        }
        if (destroySpeed > 10.0f) {
            return false;
        }
        return blockState.m_60819_().m_76178_();
    }

    private boolean isBlockBlockingPath(BlockPos blockPos) {
        PathNavigation navigation = this.creeper.m_21573_();
        Level level = this.creeper.m_9236_();
        BlockState originalState = level.m_8055_(blockPos);
        Vec3 creeperPos = this.creeper.m_20182_();
        Vec3 targetPos = this.creeper.m_5448_().m_20182_();
        Vec3 blockCenter = Vec3.m_82512_((Vec3i)blockPos);
        double distCreeperToBlock = creeperPos.m_82554_(blockCenter);
        double distCreeperToTarget = creeperPos.m_82554_(targetPos);
        double distBlockToTarget = blockCenter.m_82554_(targetPos);
        return distCreeperToBlock + distBlockToTarget <= distCreeperToTarget + 2.0;
    }

    private int getBreakingTime(BlockPos blockPos) {
        Level level = this.creeper.m_9236_();
        BlockState blockState = level.m_8055_(blockPos);
        float hardness = blockState.m_60800_((BlockGetter)level, blockPos);
        return Math.max(20, (int)(hardness * 30.0f));
    }
}

