/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreeperNapalmGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Creeper creeper;
    private static final int FIRE_DURATION = 100;
    private static final int FIRE_RADIUS = 3;
    private boolean hasRegisteredListener = false;

    public CreeperNapalmGoal(Creeper creeper) {
        this.creeper = creeper;
        this.m_7021_(EnumSet.noneOf(Goal.Flag.class));
    }

    public boolean m_8036_() {
        if (!this.hasRegisteredListener) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.hasRegisteredListener = true;
        }
        return false;
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
    }

    public void m_8041_() {
    }

    public void m_8037_() {
    }

    @SubscribeEvent
    public void onCreeperDeath(LivingDeathEvent event) {
        if (event.getEntity() == this.creeper) {
            LOGGER.debug("Creeper {} died, checking for explosion napalm effect", (Object)this.creeper.m_5446_().getString());
            if (this.creeper.m_32310_() > 0) {
                this.createNapalmEffect(this.creeper.m_20183_());
            }
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    private void createNapalmEffect(BlockPos explosionCenter) {
        Level level = this.creeper.m_9236_();
        if (level.f_46443_) {
            return;
        }
        LOGGER.debug("Creating napalm effect at {}", (Object)explosionCenter);
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                for (int y = -1; y <= 2; ++y) {
                    BlockPos firePos = explosionCenter.m_7918_(x, y, z);
                    if (!this.shouldPlaceFire(level, firePos, explosionCenter)) continue;
                    this.placeFire(level, firePos);
                }
            }
        }
    }

    private boolean shouldPlaceFire(Level level, BlockPos pos, BlockPos center) {
        double distance = Math.sqrt(pos.m_123331_((Vec3i)center));
        if (distance > 3.0) {
            return false;
        }
        BlockState blockState = level.m_8055_(pos);
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (blockState.m_60734_() == Blocks.f_49990_ || blockState.m_60734_() == Blocks.f_49991_) {
            return false;
        }
        if (blockState.m_60795_() && belowState.m_280296_()) {
            return true;
        }
        if (blockState.m_60734_().isFlammable(blockState, (BlockGetter)level, pos, null)) {
            return true;
        }
        return level.f_46441_.m_188501_() < 0.7f;
    }

    private void placeFire(Level level, BlockPos pos) {
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60734_().isFlammable(currentState, (BlockGetter)level, pos, null)) {
            level.m_46961_(pos, false);
        }
        if (level.m_8055_(pos).m_60795_()) {
            level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
            level.m_186460_(pos, Blocks.f_50083_, 100);
        }
    }
}

