/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreeperOmniscienceGoal
extends TargetGoal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Creeper creeper;
    private final double detectionRadius;
    private Player targetPlayer;
    private int searchCooldown;
    private final TargetingConditions targetingConditions;

    public CreeperOmniscienceGoal(Creeper creeper, double detectionRadius) {
        super((Mob)creeper, false);
        this.creeper = creeper;
        this.detectionRadius = detectionRadius;
        this.searchCooldown = 0;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetingConditions = TargetingConditions.m_148352_().m_26883_(detectionRadius).m_148355_();
    }

    public boolean m_8036_() {
        if (this.searchCooldown > 0) {
            --this.searchCooldown;
            return false;
        }
        this.targetPlayer = this.findNearestPlayer();
        if (this.targetPlayer != null) {
            LOGGER.debug("Creeper {} detected player {} at distance {}", (Object)this.creeper.m_5446_().getString(), (Object)this.targetPlayer.m_5446_().getString(), (Object)this.creeper.m_20182_().m_82554_(this.targetPlayer.m_20182_()));
            return true;
        }
        this.searchCooldown = 20;
        return false;
    }

    public boolean m_8045_() {
        if (this.targetPlayer == null || !this.targetPlayer.m_6084_()) {
            return false;
        }
        double distance = this.creeper.m_20182_().m_82554_(this.targetPlayer.m_20182_());
        if (distance > this.detectionRadius) {
            LOGGER.debug("Creeper {} lost player {} (distance: {})", (Object)this.creeper.m_5446_().getString(), (Object)this.targetPlayer.m_5446_().getString(), (Object)distance);
            return false;
        }
        return true;
    }

    public void m_8056_() {
        if (this.targetPlayer != null) {
            this.creeper.m_6710_((LivingEntity)this.targetPlayer);
            LOGGER.debug("Creeper {} started targeting player {}", (Object)this.creeper.m_5446_().getString(), (Object)this.targetPlayer.m_5446_().getString());
        }
    }

    public void m_8041_() {
        this.targetPlayer = null;
        this.searchCooldown = 20;
    }

    public void m_8037_() {
        if (this.targetPlayer != null && this.targetPlayer.m_6084_()) {
            this.creeper.m_6710_((LivingEntity)this.targetPlayer);
        }
    }

    private Player findNearestPlayer() {
        AABB searchArea = new AABB(this.creeper.m_20185_() - this.detectionRadius, this.creeper.m_20186_() - this.detectionRadius, this.creeper.m_20189_() - this.detectionRadius, this.creeper.m_20185_() + this.detectionRadius, this.creeper.m_20186_() + this.detectionRadius, this.creeper.m_20189_() + this.detectionRadius);
        List players = this.creeper.m_9236_().m_45976_(Player.class, searchArea);
        Player nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Player player : players) {
            double distance;
            if (player.m_7500_() || player.m_5833_() || !((distance = this.creeper.m_20182_().m_82554_(player.m_20182_())) <= this.detectionRadius) || !(distance < nearestDistance) || !this.targetingConditions.m_26885_((LivingEntity)this.creeper, (LivingEntity)player)) continue;
            nearestPlayer = player;
            nearestDistance = distance;
        }
        return nearestPlayer;
    }
}

