/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreeperWallExplosionGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Creeper creeper;
    private BlockPos wallPosition;
    private int explosionTimer;
    private int maxExplosionTime;
    private int pathCheckCooldown;
    private static final int EXPLOSION_DELAY = 60;

    public CreeperWallExplosionGoal(Creeper creeper) {
        this.creeper = creeper;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.creeper.m_5448_() == null || !this.creeper.m_5448_().m_6084_()) {
            return false;
        }
        if (this.creeper.m_32311_()) {
            return false;
        }
        if (this.pathCheckCooldown > 0) {
            --this.pathCheckCooldown;
            return false;
        }
        PathNavigation navigation = this.creeper.m_21573_();
        Path pathToTarget = navigation.m_6570_((Entity)this.creeper.m_5448_(), 0);
        if (pathToTarget != null && pathToTarget.m_77403_()) {
            this.pathCheckCooldown = 40;
            return false;
        }
        BlockPos wallPos = this.findWallToExplodeAt();
        if (wallPos != null) {
            this.wallPosition = wallPos;
            this.explosionTimer = 0;
            this.maxExplosionTime = 60;
            this.pathCheckCooldown = 0;
            return true;
        }
        this.pathCheckCooldown = 40;
        return false;
    }

    public boolean m_8045_() {
        if (this.creeper.m_5448_() == null || !this.creeper.m_5448_().m_6084_()) {
            return false;
        }
        if (this.wallPosition == null) {
            return false;
        }
        if (this.creeper.m_32311_()) {
            return false;
        }
        PathNavigation navigation = this.creeper.m_21573_();
        Path pathToTarget = navigation.m_6570_((Entity)this.creeper.m_5448_(), 0);
        return pathToTarget == null || !pathToTarget.m_77403_();
    }

    public void m_8056_() {
        LOGGER.debug("Creeper {} starting wall explosion sequence at {}", (Object)this.creeper.m_5446_().getString(), (Object)this.wallPosition);
    }

    public void m_8041_() {
        this.wallPosition = null;
        this.explosionTimer = 0;
        this.pathCheckCooldown = 60;
        this.creeper.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.wallPosition == null) {
            return;
        }
        double distance = this.creeper.m_20238_(Vec3.m_82512_((Vec3i)this.wallPosition));
        if (distance > 9.0) {
            this.creeper.m_21573_().m_26519_((double)this.wallPosition.m_123341_(), (double)this.wallPosition.m_123342_(), (double)this.wallPosition.m_123343_(), 1.0);
            return;
        }
        this.creeper.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)this.wallPosition));
        ++this.explosionTimer;
        if (this.explosionTimer >= this.maxExplosionTime) {
            LOGGER.debug("Creeper {} exploding at wall position {}", (Object)this.creeper.m_5446_().getString(), (Object)this.wallPosition);
            this.creeper.m_32312_();
            this.m_8041_();
        }
    }

    private BlockPos findWallToExplodeAt() {
        if (this.creeper.m_5448_() == null) {
            return null;
        }
        Vec3 creeperPos = this.creeper.m_20182_();
        Vec3 targetPos = this.creeper.m_5448_().m_20182_();
        Vec3 direction = targetPos.m_82546_(creeperPos).m_82541_();
        for (int i = 1; i <= 8; ++i) {
            Vec3 checkPos = creeperPos.m_82549_(direction.m_82490_((double)i));
            BlockPos blockPos = new BlockPos((int)checkPos.f_82479_, (int)checkPos.f_82480_, (int)checkPos.f_82481_);
            Level level = this.creeper.m_9236_();
            BlockState blockState = level.m_8055_(blockPos);
            if (!this.isWallBlock(blockState, blockPos) || !this.isPartOfWall(blockPos)) continue;
            return blockPos;
        }
        return null;
    }

    private boolean isWallBlock(BlockState blockState, BlockPos pos) {
        if (blockState.m_60795_()) {
            return false;
        }
        Block block = blockState.m_60734_();
        if (block == Blocks.f_50752_ || block == Blocks.f_50375_ || block == Blocks.f_50272_ || block == Blocks.f_50448_ || block == Blocks.f_50447_ || block == Blocks.f_50677_) {
            return false;
        }
        return blockState.m_280296_();
    }

    private boolean isPartOfWall(BlockPos blockPos) {
        Level level = this.creeper.m_9236_();
        int solidBlockCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos neighborPos;
                BlockState neighborState;
                if (x == 0 && z == 0 || !(neighborState = level.m_8055_(neighborPos = blockPos.m_7918_(x, 0, z))).m_280296_()) continue;
                ++solidBlockCount;
            }
        }
        BlockPos above = blockPos.m_7494_();
        BlockPos below = blockPos.m_7495_();
        if (level.m_8055_(above).m_280296_()) {
            ++solidBlockCount;
        }
        if (level.m_8055_(below).m_280296_()) {
            ++solidBlockCount;
        }
        return solidBlockCount >= 2;
    }
}

