/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import com.smartmobs.config.SmartMobsConfig;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EndermanSlenderEffectsGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EnderMan enderman;
    private final Random random;
    private int effectTick;
    private int stalkingTick;
    private Player targetPlayer;
    private final double effectRange = (Double)SmartMobsConfig.ENDERMAN_SLENDER_RANGE.get();
    private final double stalkingRange = (Double)SmartMobsConfig.ENDERMAN_SLENDER_RANGE.get() * 1.5;
    private static final int EFFECT_INTERVAL = 30;
    private static final int STALKING_INTERVAL = 15;

    public EndermanSlenderEffectsGoal(EnderMan enderman) {
        this.enderman = enderman;
        this.random = new Random();
        this.effectTick = 0;
        this.stalkingTick = 0;
        this.targetPlayer = null;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.findNearbyPlayer() != null;
    }

    public boolean m_8045_() {
        return this.findNearbyPlayer() != null;
    }

    public void m_8056_() {
        this.targetPlayer = this.findNearbyPlayer();
        this.effectTick = 0;
        this.stalkingTick = 0;
    }

    public void m_8041_() {
        this.targetPlayer = null;
    }

    public void m_8037_() {
        this.targetPlayer = this.findNearbyPlayer();
        if (this.targetPlayer != null) {
            ++this.effectTick;
            ++this.stalkingTick;
            Vec3 endermanPos = this.enderman.m_20182_();
            Vec3 playerPos = this.targetPlayer.m_20182_();
            double distance = endermanPos.m_82554_(playerPos);
            LOGGER.debug("Enderman {} effects tick - player: {}, distance: {}", (Object)this.enderman.m_5446_().getString(), (Object)this.targetPlayer.m_5446_().getString(), (Object)distance);
            if (this.effectTick >= 30) {
                LOGGER.debug("Enderman {} applying slender effects to player {}", (Object)this.enderman.m_5446_().getString(), (Object)this.targetPlayer.m_5446_().getString());
                this.applySlenderEffects(this.targetPlayer);
                this.effectTick = 0;
            }
            if (this.stalkingTick >= 15) {
                this.performStalkingBehavior(this.targetPlayer);
                this.stalkingTick = 0;
            }
        }
    }

    private Player findNearbyPlayer() {
        Level level = this.enderman.m_9236_();
        Vec3 endermanPos = this.enderman.m_20182_();
        AABB searchArea = new AABB(endermanPos.f_82479_ - this.stalkingRange, endermanPos.f_82480_ - this.stalkingRange, endermanPos.f_82481_ - this.stalkingRange, endermanPos.f_82479_ + this.stalkingRange, endermanPos.f_82480_ + this.stalkingRange, endermanPos.f_82481_ + this.stalkingRange);
        List players = level.m_45976_(Player.class, searchArea);
        Player nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Player player : players) {
            double distance;
            if (player.m_7500_() || player.m_5833_() || !((distance = endermanPos.m_82554_(player.m_20182_())) < nearestDistance)) continue;
            nearestPlayer = player;
            nearestDistance = distance;
        }
        return nearestPlayer;
    }

    private void applySlenderEffects(Player player) {
        Level level = this.enderman.m_9236_();
        Vec3 endermanPos = this.enderman.m_20182_();
        Vec3 playerPos = player.m_20182_();
        double distance = endermanPos.m_82554_(playerPos);
        LOGGER.debug("Enderman {} applying effects - distance: {}, range: {}", (Object)this.enderman.m_5446_().getString(), (Object)distance, (Object)this.effectRange);
        if (distance > this.effectRange) {
            LOGGER.debug("Player {} too far from enderman {} for effects", (Object)player.m_5446_().getString(), (Object)this.enderman.m_5446_().getString());
            return;
        }
        float intensity = (float)(1.0 - distance / this.effectRange);
        boolean isLookingAtEnderman = this.isPlayerLookingAtEnderman(player);
        LOGGER.debug("Effect intensity: {}, looking at enderman: {}", (Object)Float.valueOf(intensity), (Object)isLookingAtEnderman);
        if (distance <= 12.0) {
            LOGGER.debug("Applying intense effects to player {}", (Object)player.m_5446_().getString());
            this.applyIntenseEffects(player, intensity, isLookingAtEnderman);
        } else if (distance <= 20.0) {
            LOGGER.debug("Applying moderate effects to player {}", (Object)player.m_5446_().getString());
            this.applyModerateEffects(player, intensity, isLookingAtEnderman);
        } else {
            LOGGER.debug("Applying subtle effects to player {}", (Object)player.m_5446_().getString());
            this.applySubtleEffects(player, intensity, isLookingAtEnderman);
        }
        if (this.random.nextFloat() < 0.12f * intensity) {
            LOGGER.debug("Performing jump scare on player {}", (Object)player.m_5446_().getString());
            this.performJumpScare(player);
        }
    }

    private void applyIntenseEffects(Player player, float intensity, boolean isLookingAtEnderman) {
        LOGGER.debug("Applying intense effects with intensity {} to player {}", (Object)Float.valueOf(intensity), (Object)player.m_5446_().getString());
        if (isLookingAtEnderman) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 80, 0, false, false));
            LOGGER.debug("Applied blindness and confusion to player {}", (Object)player.m_5446_().getString());
        }
        int slowLevel = Math.round(intensity * 1.5f);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, slowLevel, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 60, slowLevel, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 0, false, false));
        LOGGER.debug("Applied slowness ({}), mining fatigue ({}), and weakness to player {}", (Object)slowLevel, (Object)slowLevel, (Object)player.m_5446_().getString());
        this.spawnDarkParticles(player, 15);
    }

    private void applyModerateEffects(Player player, float intensity, boolean isLookingAtEnderman) {
        if (isLookingAtEnderman) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 40, 0, false, false));
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0, false, false));
        if (this.random.nextFloat() < 0.5f) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 40, 0, false, false));
        }
        this.spawnDarkParticles(player, 10);
    }

    private void applySubtleEffects(Player player, float intensity, boolean isLookingAtEnderman) {
        if (isLookingAtEnderman && this.random.nextFloat() < 0.2f) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 20, 0, false, false));
        }
        if (this.random.nextFloat() < 0.6f) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 0, false, false));
        }
        this.spawnDarkParticles(player, 5);
    }

    private void performJumpScare(Player player) {
        Level level = this.enderman.m_9236_();
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11850_, player.m_5720_(), 1.0f, 0.8f);
        for (int i = 0; i < 50; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123765_, player.m_20185_() + (this.random.nextDouble() - 0.5) * 4.0, player.m_20186_() + this.random.nextDouble() * 3.0, player.m_20189_() + (this.random.nextDouble() - 0.5) * 4.0, (this.random.nextDouble() - 0.5) * 0.5, this.random.nextDouble() * 0.5, (this.random.nextDouble() - 0.5) * 0.5);
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 20, 1, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 1, false, false));
        LOGGER.debug("Enderman {} performed jump scare on player {}", (Object)this.enderman.m_5446_().getString(), (Object)player.m_5446_().getString());
    }

    private void performStalkingBehavior(Player player) {
        Vec3 playerPos = player.m_20182_();
        Vec3 endermanPos = this.enderman.m_20182_();
        double distance = endermanPos.m_82554_(playerPos);
        if (!this.isPlayerLookingAtEnderman(player) && distance > 8.0 && distance < 24.0 && this.random.nextFloat() < 0.35f) {
            this.teleportBehindPlayer(player);
        }
        if (this.isPlayerLookingAtEnderman(player) && distance < 12.0 && this.random.nextFloat() < 0.45f) {
            this.teleportAwayFromPlayer(player);
        }
    }

    private void teleportBehindPlayer(Player player) {
        Level level = this.enderman.m_9236_();
        Vec3 playerPos = player.m_20182_();
        Vec3 playerLook = player.m_20154_();
        Vec3 behindPos = playerPos.m_82546_(playerLook.m_82490_(8.0));
        for (int attempt = 0; attempt < 10; ++attempt) {
            double x = behindPos.f_82479_ + (this.random.nextDouble() - 0.5) * 4.0;
            double z = behindPos.f_82481_ + (this.random.nextDouble() - 0.5) * 4.0;
            double y = behindPos.f_82480_ + (this.random.nextDouble() - 0.5) * 2.0;
            if (!this.enderman.m_20984_(x, y, z, true)) continue;
            level.m_6263_(null, x, y, z, SoundEvents.f_11852_, this.enderman.m_5720_(), 0.5f, 1.0f);
            break;
        }
    }

    private void teleportAwayFromPlayer(Player player) {
        Level level = this.enderman.m_9236_();
        Vec3 playerPos = player.m_20182_();
        Vec3 endermanPos = this.enderman.m_20182_();
        Vec3 awayDirection = endermanPos.m_82546_(playerPos).m_82541_();
        Vec3 teleportPos = endermanPos.m_82549_(awayDirection.m_82490_(16.0));
        for (int attempt = 0; attempt < 10; ++attempt) {
            double x = teleportPos.f_82479_ + (this.random.nextDouble() - 0.5) * 6.0;
            double z = teleportPos.f_82481_ + (this.random.nextDouble() - 0.5) * 6.0;
            double y = teleportPos.f_82480_ + (this.random.nextDouble() - 0.5) * 4.0;
            if (!this.enderman.m_20984_(x, y, z, true)) continue;
            level.m_6263_(null, x, y, z, SoundEvents.f_11852_, this.enderman.m_5720_(), 0.5f, 1.0f);
            break;
        }
    }

    private boolean isPlayerLookingAtEnderman(Player player) {
        Vec3 toEnderman;
        Vec3 playerPos = player.m_146892_();
        Vec3 endermanPos = this.enderman.m_146892_();
        Vec3 playerLook = player.m_20154_();
        double dot = playerLook.m_82526_(toEnderman = endermanPos.m_82546_(playerPos).m_82541_());
        return dot > 0.8;
    }

    private void spawnDarkParticles(Player player, int count) {
        Level level = this.enderman.m_9236_();
        for (int i = 0; i < count; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123765_, player.m_20185_() + (this.random.nextDouble() - 0.5) * 2.0, player.m_20186_() + this.random.nextDouble() * 2.0, player.m_20189_() + (this.random.nextDouble() - 0.5) * 2.0, (this.random.nextDouble() - 0.5) * 0.2, this.random.nextDouble() * 0.2, (this.random.nextDouble() - 0.5) * 0.2);
        }
    }
}

