/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import com.smartmobs.config.SmartMobsConfig;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EndermanTeleportPlayerGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EnderMan enderman;
    private final Random random;
    private int teleportCooldown;
    private int checkTick;
    private static final int CHECK_INTERVAL = 20;
    private static final int MAX_TELEPORT_ATTEMPTS = 15;

    public EndermanTeleportPlayerGoal(EnderMan enderman) {
        this.enderman = enderman;
        this.random = new Random();
        this.teleportCooldown = 0;
        this.checkTick = 0;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        Player target;
        Player player = target = this.enderman.m_5448_() instanceof Player ? (Player)this.enderman.m_5448_() : null;
        if (target != null) {
            LOGGER.debug("Enderman {} can use teleport goal - target: {}", (Object)this.enderman.m_5446_().getString(), (Object)target.m_5446_().getString());
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        Player target = this.enderman.m_5448_() instanceof Player ? (Player)this.enderman.m_5448_() : null;
        return target != null;
    }

    public void m_8056_() {
        this.checkTick = 0;
        LOGGER.debug("Enderman {} started teleport player goal", (Object)this.enderman.m_5446_().getString());
    }

    public void m_8037_() {
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
        }
        ++this.checkTick;
        if (this.checkTick >= 20) {
            LivingEntity livingEntity;
            this.checkTick = 0;
            if (this.teleportCooldown <= 0 && (livingEntity = this.enderman.m_5448_()) instanceof Player) {
                Player player = (Player)livingEntity;
                double distance = this.enderman.m_20182_().m_82554_(player.m_20182_());
                LOGGER.debug("Enderman {} checking teleport - distance: {}, cooldown: {}", (Object)this.enderman.m_5446_().getString(), (Object)distance, (Object)this.teleportCooldown);
                if (distance <= 3.0) {
                    if ((double)this.random.nextFloat() < (Double)SmartMobsConfig.ENDERMAN_TELEPORT_CHANCE.get()) {
                        LOGGER.debug("Enderman {} attempting to teleport player {} (close range)", (Object)this.enderman.m_5446_().getString(), (Object)player.m_5446_().getString());
                        this.teleportPlayer(player);
                        this.teleportCooldown = (Integer)SmartMobsConfig.ENDERMAN_TELEPORT_COOLDOWN.get();
                    }
                } else if (distance <= 8.0 && (double)this.random.nextFloat() < (Double)SmartMobsConfig.ENDERMAN_TELEPORT_CHANCE.get() * 0.4) {
                    LOGGER.debug("Enderman {} attempting to teleport player {} (medium range)", (Object)this.enderman.m_5446_().getString(), (Object)player.m_5446_().getString());
                    this.teleportPlayer(player);
                    this.teleportCooldown = (Integer)SmartMobsConfig.ENDERMAN_TELEPORT_COOLDOWN.get();
                }
            }
        }
    }

    private void teleportPlayer(Player player) {
        Level level = this.enderman.m_9236_();
        Vec3 endermanPos = this.enderman.m_20182_();
        LOGGER.debug("Enderman {} starting teleport process for player {}", (Object)this.enderman.m_5446_().getString(), (Object)player.m_5446_().getString());
        for (int attempt = 0; attempt < 15; ++attempt) {
            double angle = this.random.nextDouble() * 2.0 * Math.PI;
            double distance = 10.0 + this.random.nextDouble() * ((Double)SmartMobsConfig.ENDERMAN_TELEPORT_RANGE.get() - 10.0);
            double x = endermanPos.f_82479_ + Math.cos(angle) * distance;
            double z = endermanPos.f_82481_ + Math.sin(angle) * distance;
            for (int yOffset = -5; yOffset <= 5; ++yOffset) {
                double y = endermanPos.f_82480_ + (double)yOffset;
                BlockPos targetPos = new BlockPos((int)x, (int)y, (int)z);
                if (!this.isValidTeleportLocation(level, targetPos)) continue;
                double teleportX = (double)targetPos.m_123341_() + 0.5;
                double teleportY = targetPos.m_123342_();
                double teleportZ = (double)targetPos.m_123343_() + 0.5;
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, player.m_5720_(), 1.0f, 1.0f);
                player.m_6021_(teleportX, teleportY, teleportZ);
                level.m_6263_(null, teleportX, teleportY, teleportZ, SoundEvents.f_11852_, player.m_5720_(), 1.0f, 1.0f);
                this.spawnTeleportParticles(level, player.m_20185_(), player.m_20186_(), player.m_20189_());
                this.spawnTeleportParticles(level, teleportX, teleportY, teleportZ);
                LOGGER.info("Enderman {} successfully teleported player {} to {}", (Object)this.enderman.m_5446_().getString(), (Object)player.m_5446_().getString(), (Object)targetPos);
                return;
            }
        }
        LOGGER.debug("Enderman {} failed to find valid teleport location, using fallback", (Object)this.enderman.m_5446_().getString());
        this.fallbackTeleport(player);
    }

    private void spawnTeleportParticles(Level level, double x, double y, double z) {
        for (int i = 0; i < 32; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, x + (this.random.nextDouble() - 0.5) * 2.0, y + this.random.nextDouble() * 2.0, z + (this.random.nextDouble() - 0.5) * 2.0, (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
        }
    }

    private void fallbackTeleport(Player player) {
        Level level = this.enderman.m_9236_();
        Vec3 endermanPos = this.enderman.m_20182_();
        double angle = this.random.nextDouble() * 2.0 * Math.PI;
        double distance = 10.0 + this.random.nextDouble() * 10.0;
        double x = endermanPos.f_82479_ + Math.cos(angle) * distance;
        double z = endermanPos.f_82481_ + Math.sin(angle) * distance;
        double y = endermanPos.f_82480_;
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, player.m_5720_(), 1.0f, 1.0f);
        player.m_6021_(x, y, z);
        level.m_6263_(null, x, y, z, SoundEvents.f_11852_, player.m_5720_(), 1.0f, 1.0f);
        this.spawnTeleportParticles(level, player.m_20185_(), player.m_20186_(), player.m_20189_());
        this.spawnTeleportParticles(level, x, y, z);
        LOGGER.info("Enderman {} fallback teleported player {} to {},{},{}", (Object)this.enderman.m_5446_().getString(), (Object)player.m_5446_().getString(), (Object)x, (Object)y, (Object)z);
    }

    private boolean isValidTeleportLocation(Level level, BlockPos pos) {
        if (pos.m_123342_() < level.m_141937_() || pos.m_123342_() > level.m_151558_() - 2) {
            return false;
        }
        BlockState floorState = level.m_8055_(pos.m_7495_());
        if (!floorState.m_280296_()) {
            return false;
        }
        BlockState posState = level.m_8055_(pos);
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        if (!(posState.m_60795_() || posState.m_60713_(Blocks.f_49990_) || posState.m_60713_(Blocks.f_49991_))) {
            return false;
        }
        if (!(aboveState.m_60795_() || aboveState.m_60713_(Blocks.f_49990_) || aboveState.m_60713_(Blocks.f_49991_))) {
            return false;
        }
        return !posState.m_60713_(Blocks.f_49991_) && !aboveState.m_60713_(Blocks.f_49991_);
    }
}

