/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import com.smartmobs.config.SmartMobsConfig;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkeletonSniperGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AbstractSkeleton skeleton;
    private LivingEntity target;
    private int attackTime;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private double lastTargetX;
    private double lastTargetY;
    private double lastTargetZ;
    private int aimTime;
    private final int maxAimTime = 10;
    private final double maxRange = (Double)SmartMobsConfig.SKELETON_SNIPER_RANGE.get();
    private final double minRange = 25.0;
    private final double retreatRange = 15.0;
    private boolean isRetreating = false;

    public SkeletonSniperGoal(AbstractSkeleton skeleton) {
        this.skeleton = skeleton;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.skeleton.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        return this.skeleton.m_21205_().m_41720_() instanceof BowItem;
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.skeleton.m_21573_().m_26571_()) && this.hasLineOfSight();
    }

    public void m_8056_() {
        super.m_8056_();
        this.skeleton.m_21561_(true);
        this.aimTime = 0;
        if (this.skeleton.m_21205_().m_41619_()) {
            this.skeleton.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
        this.skeleton.m_21561_(false);
        this.skeleton.m_5810_();
        this.aimTime = 0;
    }

    public void m_8037_() {
        boolean hasSeenRecently;
        LivingEntity target = this.skeleton.m_5448_();
        if (target == null) {
            return;
        }
        this.target = target;
        double distanceToTarget = this.skeleton.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        boolean canSee = this.skeleton.m_21574_().m_148306_((Entity)target);
        boolean bl = hasSeenRecently = this.seeTime > 0;
        if (canSee != hasSeenRecently) {
            this.seeTime = 0;
        }
        this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
        double distance = Math.sqrt(distanceToTarget);
        if (distance <= this.retreatRange && canSee) {
            this.isRetreating = true;
            this.retreatFromTarget(target);
            this.strafingTime = -1;
        } else if (distance > this.maxRange) {
            this.isRetreating = false;
            this.skeleton.m_21573_().m_5624_((Entity)target, 1.0);
            this.strafingTime = -1;
        } else if (this.seeTime >= 10) {
            this.isRetreating = false;
            this.skeleton.m_21573_().m_26573_();
            ++this.strafingTime;
        } else {
            this.isRetreating = false;
            this.skeleton.m_21573_().m_5624_((Entity)target, 1.0);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.skeleton.m_217043_().m_188501_() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.skeleton.m_217043_().m_188501_() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1 && !this.isRetreating) {
            if (distanceToTarget > this.minRange * this.minRange) {
                this.strafingBackwards = false;
            } else if (distanceToTarget < this.minRange * this.minRange * 0.75) {
                this.strafingBackwards = true;
            }
            this.skeleton.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.skeleton.m_21391_((Entity)target, 10.0f, 10.0f);
        } else {
            this.skeleton.m_21563_().m_24960_((Entity)target, 5.0f, 5.0f);
        }
        if (this.skeleton.m_6117_()) {
            int useTime;
            if (!canSee && this.seeTime < -60) {
                this.skeleton.m_5810_();
                this.aimTime = 0;
            } else if (canSee && (useTime = this.skeleton.m_21252_()) >= 8) {
                this.skeleton.m_5810_();
                this.performSniperShot(target);
                this.attackTime = 5;
                this.aimTime = 0;
            }
        } else if (--this.attackTime <= 0 && this.seeTime >= -10 && canSee && distanceToTarget <= this.maxRange * this.maxRange) {
            ++this.aimTime;
            if (this.aimTime >= this.maxAimTime) {
                this.skeleton.m_6672_(InteractionHand.MAIN_HAND);
            }
        }
        this.trackTargetMovement(target);
    }

    private void performSniperShot(LivingEntity target) {
        ItemStack bowStack = this.skeleton.m_21205_();
        if (!(bowStack.m_41720_() instanceof BowItem)) {
            return;
        }
        Arrow arrow = new Arrow(this.skeleton.m_9236_(), (LivingEntity)this.skeleton);
        double deltaX = target.m_20185_() - this.skeleton.m_20185_();
        double deltaY = target.m_20227_(0.33) - arrow.m_20186_();
        double deltaZ = target.m_20189_() - this.skeleton.m_20189_();
        double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        Vec3 targetVelocity = this.predictTargetMovement(target, horizontalDistance);
        arrow.m_6686_(deltaX += targetVelocity.f_82479_, (deltaY += targetVelocity.f_82480_) + horizontalDistance * 0.08, deltaZ += targetVelocity.f_82481_, 2.2f, 0.02f);
        if (this.skeleton.m_9236_().f_46441_.m_188501_() < 0.25f) {
            arrow.m_20254_(100);
        }
        arrow.m_36781_(arrow.m_36789_() * (Double)SmartMobsConfig.SKELETON_ACCURACY_MULTIPLIER.get());
        arrow.m_36762_(true);
        this.skeleton.m_9236_().m_7967_((Entity)arrow);
        this.skeleton.m_6674_(InteractionHand.MAIN_HAND);
        LOGGER.debug("Skeleton performed sniper shot at target: {}", (Object)target.m_5446_().getString());
    }

    private Vec3 predictTargetMovement(LivingEntity target, double timeToTarget) {
        double timeFactor = timeToTarget / 12.0;
        Vec3 currentVelocity = target.m_20184_();
        double deltaX = currentVelocity.f_82479_ * timeFactor * 1.8;
        double deltaY = currentVelocity.f_82480_ * timeFactor * 1.5;
        double deltaZ = currentVelocity.f_82481_ * timeFactor * 1.8;
        double lastDeltaX = target.m_20185_() - this.lastTargetX;
        double lastDeltaY = target.m_20186_() - this.lastTargetY;
        double lastDeltaZ = target.m_20189_() - this.lastTargetZ;
        deltaX += lastDeltaX * timeFactor * 0.8;
        deltaY += lastDeltaY * timeFactor * 0.8;
        deltaZ += lastDeltaZ * timeFactor * 0.8;
        if (target.m_20096_() && target.m_20184_().f_82480_ > 0.0) {
            deltaY += 0.5;
        }
        if (target.m_20142_()) {
            deltaX *= 1.3;
            deltaZ *= 1.3;
        }
        return new Vec3(deltaX, deltaY, deltaZ);
    }

    private void trackTargetMovement(LivingEntity target) {
        this.lastTargetX = target.m_20185_();
        this.lastTargetY = target.m_20186_();
        this.lastTargetZ = target.m_20189_();
    }

    private boolean hasLineOfSight() {
        return this.target != null && this.skeleton.m_21574_().m_148306_((Entity)this.target);
    }

    private void retreatFromTarget(LivingEntity target) {
        double deltaZ;
        double deltaX = this.skeleton.m_20185_() - target.m_20185_();
        double distance = Math.sqrt(deltaX * deltaX + (deltaZ = this.skeleton.m_20189_() - target.m_20189_()) * deltaZ);
        if (distance > 0.0) {
            double normalizedX = deltaX / distance;
            double normalizedZ = deltaZ / distance;
            double retreatX = this.skeleton.m_20185_() + normalizedX * this.retreatRange;
            double retreatZ = this.skeleton.m_20189_() + normalizedZ * this.retreatRange;
            this.skeleton.m_21573_().m_26519_(retreatX, this.skeleton.m_20186_(), retreatZ, 1.2);
        }
    }
}

