/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpiderWebAttackGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Spider spider;
    private LivingEntity target;
    private int attackCooldown;
    private static final int ATTACK_COOLDOWN_TIME = 20;
    private static final double ATTACK_RANGE = 3.0;

    public SpiderWebAttackGoal(Spider spider) {
        this.spider = spider;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
            return false;
        }
        LivingEntity potentialTarget = this.spider.m_5448_();
        if (potentialTarget == null || !potentialTarget.m_6084_()) {
            return false;
        }
        if (!this.isTargetInWeb(potentialTarget)) {
            return false;
        }
        double distanceToTarget = this.spider.m_20270_((Entity)potentialTarget);
        if (distanceToTarget > 3.0) {
            return false;
        }
        this.target = potentialTarget;
        return true;
    }

    public boolean m_8045_() {
        return this.target != null && this.target.m_6084_() && this.isTargetInWeb(this.target) && (double)this.spider.m_20270_((Entity)this.target) <= 3.0;
    }

    public void m_8056_() {
        LOGGER.debug("Spider starting web attack on target: {}", (Object)this.target.m_5446_().getString());
        this.spider.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
    }

    public void m_8041_() {
        this.target = null;
        this.attackCooldown = 20;
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        this.spider.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        double distanceToTarget = this.spider.m_20270_((Entity)this.target);
        if (distanceToTarget > 1.5) {
            this.spider.m_21573_().m_5624_((Entity)this.target, 1.5);
        } else {
            this.spider.m_7327_((Entity)this.target);
            this.attackCooldown = 20;
        }
    }

    private boolean isTargetInWeb(LivingEntity target) {
        BlockPos targetPos = target.m_20183_();
        Level level = this.spider.m_9236_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 1; ++y) {
                    BlockPos checkPos = targetPos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(checkPos);
                    if (state.m_60734_() != Blocks.f_50033_) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

