/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpiderWebGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Spider spider;
    private LivingEntity target;
    private int webCooldown;
    private int webDuration;
    private static final int WEB_COOLDOWN_TIME = 100;
    private static final int WEB_DURATION_TIME = 200;
    private static final double WEB_RANGE = 8.0;

    public SpiderWebGoal(Spider spider) {
        this.spider = spider;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.webCooldown > 0) {
            --this.webCooldown;
            return false;
        }
        LivingEntity potentialTarget = this.spider.m_5448_();
        if (potentialTarget == null || !potentialTarget.m_6084_()) {
            return false;
        }
        double distanceToTarget = this.spider.m_20270_((Entity)potentialTarget);
        if (distanceToTarget > 8.0 || distanceToTarget < 2.0) {
            return false;
        }
        if (this.hasLineOfSight(potentialTarget)) {
            this.target = potentialTarget;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.target != null && this.target.m_6084_() && this.webDuration > 0;
    }

    public void m_8056_() {
        this.webDuration = 200;
        this.webCooldown = 100;
        LOGGER.debug("Spider starting to web target: {}", (Object)this.target.m_5446_().getString());
        this.spider.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        this.createWebAroundTarget();
        Level level = this.spider.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level.m_5594_(null, this.spider.m_20183_(), SoundEvents.f_12435_, SoundSource.HOSTILE, 1.0f, 0.8f);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123753_, this.target.m_20185_(), this.target.m_20186_() + 1.0, this.target.m_20189_(), 15, 0.5, 0.5, 0.5, 0.1);
        }
    }

    public void m_8041_() {
        this.target = null;
        this.webDuration = 0;
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        --this.webDuration;
        this.spider.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        double distanceToTarget = this.spider.m_20270_((Entity)this.target);
        if (distanceToTarget > 4.0) {
            this.spider.m_21573_().m_5624_((Entity)this.target, 1.2);
        } else if (distanceToTarget > 2.5) {
            this.spider.m_21573_().m_5624_((Entity)this.target, 1.0);
        } else if (distanceToTarget < 1.5) {
            this.spider.m_21573_().m_26519_(this.target.m_20185_() + (this.spider.m_217043_().m_188500_() - 0.5) * 3.0, this.target.m_20186_(), this.target.m_20189_() + (this.spider.m_217043_().m_188500_() - 0.5) * 3.0, 0.8);
        }
        if (this.webDuration % 20 == 0) {
            this.maintainWebAroundTarget();
        }
        if (this.webDuration <= 0) {
            this.removeWebAroundTarget();
        }
    }

    private void createWebAroundTarget() {
        BlockPos targetPos = this.target.m_20183_();
        Level level = this.spider.m_9236_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos abovePos;
                BlockState aboveState;
                if (x == 0 && z == 0) continue;
                BlockPos webPos = targetPos.m_7918_(x, 0, z);
                BlockState currentState = level.m_8055_(webPos);
                if (currentState.m_60795_() || currentState.m_60734_() == Blocks.f_50034_ || currentState.m_60734_() == Blocks.f_50359_ || currentState.m_60734_() == Blocks.f_50035_) {
                    level.m_7731_(webPos, Blocks.f_50033_.m_49966_(), 3);
                }
                if (!(aboveState = level.m_8055_(abovePos = webPos.m_7494_())).m_60795_() || !(Math.random() < 0.3)) continue;
                level.m_7731_(abovePos, Blocks.f_50033_.m_49966_(), 3);
            }
        }
        BlockPos centerPos = targetPos.m_7494_();
        BlockState centerState = level.m_8055_(centerPos);
        if (centerState.m_60795_()) {
            level.m_7731_(centerPos, Blocks.f_50033_.m_49966_(), 3);
        }
    }

    private void maintainWebAroundTarget() {
        if (this.target == null) {
            return;
        }
        BlockPos targetPos = this.target.m_20183_();
        Level level = this.spider.m_9236_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos webPos;
                BlockState currentState;
                if (x == 0 && z == 0 || !(currentState = level.m_8055_(webPos = targetPos.m_7918_(x, 0, z))).m_60795_() || !(Math.random() < 0.3)) continue;
                level.m_7731_(webPos, Blocks.f_50033_.m_49966_(), 3);
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123753_, this.target.m_20185_(), this.target.m_20186_() + 0.5, this.target.m_20189_(), 5, 0.3, 0.3, 0.3, 0.05);
        }
    }

    private void removeWebAroundTarget() {
        if (this.target == null) {
            return;
        }
        BlockPos targetPos = this.target.m_20183_();
        Level level = this.spider.m_9236_();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = -1; y <= 2; ++y) {
                    BlockPos webPos = targetPos.m_7918_(x, y, z);
                    BlockState currentState = level.m_8055_(webPos);
                    if (currentState.m_60734_() != Blocks.f_50033_) continue;
                    level.m_46961_(webPos, false);
                }
            }
        }
    }

    private boolean hasLineOfSight(LivingEntity target) {
        Vec3 spiderPos = this.spider.m_20182_().m_82520_(0.0, (double)this.spider.m_20192_(), 0.0);
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0);
        return this.spider.m_9236_().m_45547_(new ClipContext(spiderPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.spider)).m_6662_() == HitResult.Type.MISS;
    }
}

