/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZombieAutoFloorGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Zombie zombie;
    private BlockPos floorPos;
    private int buildCooldown;
    private Vec3 lastPosition;
    private int stuckTime;
    private int buildingTime;

    public ZombieAutoFloorGoal(Zombie zombie) {
        this.zombie = zombie;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.buildCooldown = 0;
        this.lastPosition = zombie.m_20182_();
        this.stuckTime = 0;
        this.buildingTime = 0;
    }

    public boolean m_8036_() {
        BlockPos nextPos;
        if (this.zombie.m_5448_() == null || !this.zombie.m_5448_().m_6084_() || this.buildCooldown > 0) {
            return false;
        }
        BlockPos zombiePos = this.zombie.m_20183_();
        Vec3 movement = this.zombie.m_20184_();
        if (this.zombie.m_20184_().f_82480_ < -0.2) {
            if (this.needsFloorAt(zombiePos)) {
                this.floorPos = zombiePos.m_7495_();
                return true;
            }
            BlockPos landingPos = zombiePos.m_7918_((int)(movement.f_82479_ * 3.0), -1, (int)(movement.f_82481_ * 3.0));
            if (this.needsFloorAt(landingPos)) {
                this.floorPos = landingPos.m_7495_();
                return true;
            }
        }
        if ((Math.abs(movement.f_82479_) > 0.1 || Math.abs(movement.f_82481_) > 0.1) && this.needsFloorAt(nextPos = zombiePos.m_7918_((int)(movement.f_82479_ * 2.0), 0, (int)(movement.f_82481_ * 2.0)))) {
            this.floorPos = nextPos.m_7495_();
            return true;
        }
        if (this.zombie.m_21573_().m_26570_() != null) {
            Vec3 targetDir = this.zombie.m_5448_().m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
            BlockPos targetStepPos = zombiePos.m_7918_((int)(targetDir.f_82479_ * 2.0), 0, (int)(targetDir.f_82481_ * 2.0));
            if (this.needsFloorAt(targetStepPos)) {
                this.floorPos = targetStepPos.m_7495_();
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.floorPos == null || this.zombie.m_5448_() == null) {
            return false;
        }
        Level level = this.zombie.m_9236_();
        BlockState blockState = level.m_8055_(this.floorPos);
        return blockState.m_60795_() || blockState.m_247087_();
    }

    public void m_8056_() {
        this.buildingTime = 0;
        if (!this.hasBlocks()) {
            this.giveBlocks();
        }
        LOGGER.debug("Zombie {} starting auto-floor building at {}", (Object)this.zombie.m_5446_().getString(), (Object)this.floorPos);
    }

    public void m_8041_() {
        this.floorPos = null;
        this.buildingTime = 0;
        this.buildCooldown = 3;
    }

    public void m_8037_() {
        double maxDistance;
        if (this.buildCooldown > 0) {
            --this.buildCooldown;
            return;
        }
        if (this.floorPos == null) {
            return;
        }
        Level level = this.zombie.m_9236_();
        double distance = this.zombie.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)this.floorPos));
        boolean isUrgent = this.zombie.m_20184_().f_82480_ < -0.2;
        double d = maxDistance = isUrgent ? 6.0 : 4.0;
        if (distance <= maxDistance) {
            int requiredTime;
            ++this.buildingTime;
            int n = requiredTime = isUrgent ? 1 : 3;
            if (this.buildingTime >= requiredTime) {
                if (this.canPlaceBlockAt(this.floorPos)) {
                    level.m_7731_(this.floorPos, Blocks.f_50652_.m_49966_(), 3);
                    level.m_5594_(null, this.floorPos, SoundEvents.f_12447_, SoundSource.HOSTILE, 0.8f, 1.0f);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50652_.m_49966_()), (double)this.floorPos.m_123341_() + 0.5, (double)this.floorPos.m_123342_() + 0.5, (double)this.floorPos.m_123343_() + 0.5, 5, 0.2, 0.2, 0.2, 0.1);
                    }
                    LOGGER.debug("Zombie {} placed auto-floor at {}", (Object)this.zombie.m_5446_().getString(), (Object)this.floorPos);
                }
                this.floorPos = null;
                this.buildingTime = 0;
            }
        }
    }

    private boolean needsFloorAt(BlockPos pos) {
        BlockPos below;
        Level level = this.zombie.m_9236_();
        BlockState belowState = level.m_8055_(below = pos.m_7495_());
        if (belowState.m_60795_()) {
            for (int i = 2; i <= 8; ++i) {
                BlockPos checkPos = pos.m_6625_(i);
                if (level.m_8055_(checkPos).m_60795_()) continue;
                return i > 2;
            }
            return true;
        }
        return false;
    }

    private boolean canPlaceBlockAt(BlockPos pos) {
        Level level = this.zombie.m_9236_();
        BlockState state = level.m_8055_(pos);
        if (!state.m_60795_() && !state.m_247087_()) {
            return false;
        }
        BlockPos above = pos.m_7494_();
        return level.m_8055_(above).m_60795_() || level.m_8055_(above).m_247087_();
    }

    private boolean hasBlocks() {
        ItemStack offHand = this.zombie.m_21120_(InteractionHand.OFF_HAND);
        return offHand.m_41720_() == Items.f_42594_ || offHand.m_41720_() == Items.f_42329_ || offHand.m_41720_() == Items.f_41905_;
    }

    private void giveBlocks() {
        ItemStack offHand = this.zombie.m_21120_(InteractionHand.OFF_HAND);
        if (offHand.m_41619_() || offHand.m_41613_() < 16) {
            this.zombie.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42594_, 64));
        }
    }
}

