/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZombieBreakBlockGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Zombie zombie;
    private BlockPos targetBlockPos;
    private int breakingTime;
    private int maxBreakingTime;
    private float breakProgress;
    private Path path;
    private int reachCheckCounter;

    public ZombieBreakBlockGoal(Zombie zombie) {
        this.zombie = zombie;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.zombie.m_5448_() == null || !this.zombie.m_5448_().m_6084_()) {
            return false;
        }
        PathNavigation navigation = this.zombie.m_21573_();
        Path pathToTarget = navigation.m_6570_((Entity)this.zombie.m_5448_(), 0);
        if (pathToTarget != null && pathToTarget.m_77403_()) {
            return false;
        }
        if (!this.shouldBreakInsteadOfBuild()) {
            return false;
        }
        BlockPos blockToBreak = this.findBlockToBreak();
        if (blockToBreak != null) {
            this.targetBlockPos = blockToBreak;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.targetBlockPos == null) {
            return false;
        }
        BlockState blockState = this.zombie.m_9236_().m_8055_(this.targetBlockPos);
        if (blockState.m_60795_()) {
            return false;
        }
        if (this.breakingTime > 0 && (double)this.breakingTime >= (double)this.maxBreakingTime * 0.5) {
            return true;
        }
        if (this.zombie.m_5448_() == null || !this.zombie.m_5448_().m_6084_()) {
            return false;
        }
        double distance = this.zombie.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)this.targetBlockPos));
        return distance <= 5.0;
    }

    public void m_8056_() {
        this.breakingTime = 0;
        this.breakProgress = 0.0f;
        this.reachCheckCounter = 0;
        if (!this.hasPickaxe()) {
            this.givePickaxe();
        }
        BlockState blockState = this.zombie.m_9236_().m_8055_(this.targetBlockPos);
        this.maxBreakingTime = this.calculateBreakTime(blockState);
        LOGGER.debug("Zombie starting to break block at {} (time: {})", (Object)this.targetBlockPos, (Object)this.maxBreakingTime);
    }

    public void m_8041_() {
        Level level;
        if (this.breakingTime > 0 && (double)this.breakingTime >= (double)this.maxBreakingTime * 0.5) {
            LOGGER.debug("Zombie {} stop() called but was {}% complete - NOT resetting", (Object)this.zombie.m_5446_().getString(), (Object)((int)(this.breakProgress * 100.0f)));
            return;
        }
        if (this.targetBlockPos != null && (level = this.zombie.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6801_(this.zombie.m_19879_(), this.targetBlockPos, -1);
        }
        this.targetBlockPos = null;
        this.breakingTime = 0;
        this.breakProgress = 0.0f;
        this.reachCheckCounter = 0;
    }

    public void m_8037_() {
        if (this.targetBlockPos == null) {
            return;
        }
        Level level = this.zombie.m_9236_();
        BlockState blockState = level.m_8055_(this.targetBlockPos);
        if (blockState.m_60795_()) {
            this.targetBlockPos = null;
            return;
        }
        this.zombie.m_21563_().m_24946_((double)this.targetBlockPos.m_123341_() + 0.5, (double)this.targetBlockPos.m_123342_() + 0.5, (double)this.targetBlockPos.m_123343_() + 0.5);
        double distance = this.zombie.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)this.targetBlockPos));
        if (distance <= 3.0) {
            this.zombie.m_6674_(InteractionHand.MAIN_HAND);
            ++this.breakingTime;
            this.breakProgress = (float)this.breakingTime / (float)this.maxBreakingTime;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_6801_(this.zombie.m_19879_(), this.targetBlockPos, (int)(this.breakProgress * 10.0f) - 1);
                if (this.breakingTime % 4 == 0) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)this.targetBlockPos.m_123341_() + 0.5, (double)this.targetBlockPos.m_123342_() + 0.5, (double)this.targetBlockPos.m_123343_() + 0.5, 3, 0.1, 0.1, 0.1, 0.01);
                    level.m_5594_(null, this.targetBlockPos, blockState.m_60827_().m_56778_(), SoundSource.HOSTILE, 0.5f, 1.0f);
                }
            }
            if (this.breakingTime >= this.maxBreakingTime) {
                if (this.canBreakBlock(blockState.m_60734_())) {
                    level.m_46961_(this.targetBlockPos, true);
                    level.m_5594_(null, this.targetBlockPos, blockState.m_60827_().m_56775_(), SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                this.targetBlockPos = null;
                this.breakingTime = 0;
            }
        } else {
            int maxAttempts;
            ++this.reachCheckCounter;
            if (this.reachCheckCounter % 10 == 0) {
                this.zombie.m_21573_().m_26519_((double)this.targetBlockPos.m_123341_() + 0.5, (double)this.targetBlockPos.m_123342_(), (double)this.targetBlockPos.m_123343_() + 0.5, 1.2);
            }
            int n = maxAttempts = this.breakingTime > 0 ? 300 : 100;
            if (this.reachCheckCounter > maxAttempts) {
                if (this.breakingTime > 0 && (double)this.breakingTime >= (double)this.maxBreakingTime * 0.3) {
                    this.reachCheckCounter = 0;
                    LOGGER.debug("Zombie {} resetting reach counter - was {}% complete", (Object)this.zombie.m_5446_().getString(), (Object)((int)(this.breakProgress * 100.0f)));
                } else {
                    this.targetBlockPos = null;
                    this.reachCheckCounter = 0;
                }
            }
        }
    }

    private BlockPos findBlockToBreak() {
        BlockPos checkPos;
        if (this.zombie.m_5448_() == null) {
            return null;
        }
        BlockPos zombiePos = this.zombie.m_20183_();
        BlockPos targetPos = this.zombie.m_5448_().m_20183_();
        Level level = this.zombie.m_9236_();
        Path pathToTarget = this.zombie.m_21573_().m_7864_(targetPos, 0);
        if (pathToTarget != null && !pathToTarget.m_77403_()) {
            for (int i = 0; i < pathToTarget.m_77398_(); ++i) {
                BlockPos nodePos = pathToTarget.m_77375_(i).m_77288_();
                for (int y = 0; y <= 1; ++y) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            BlockState state;
                            if (Math.abs(x) + Math.abs(z) != 1 || (state = level.m_8055_(checkPos = nodePos.m_7918_(x, y, z))).m_60795_() || !this.canBreakBlock(state.m_60734_()) || !this.isBlockingPath(checkPos, zombiePos, targetPos)) continue;
                            return checkPos;
                        }
                    }
                }
            }
        }
        int dx = targetPos.m_123341_() - zombiePos.m_123341_();
        int dy = targetPos.m_123342_() - zombiePos.m_123342_();
        int dz = targetPos.m_123343_() - zombiePos.m_123343_();
        if (Math.abs(dx) > Math.abs(dz)) {
            int stepX = dx > 0 ? 1 : -1;
            for (i = 1; i <= Math.abs(dx); ++i) {
                checkPos = zombiePos.m_7918_(stepX * i, 0, 0);
                for (int y = 0; y <= 2; ++y) {
                    pos = checkPos.m_6630_(y);
                    state = level.m_8055_(pos);
                    if (state.m_60795_() || !this.canBreakBlock(state.m_60734_())) continue;
                    return pos;
                }
            }
        } else if (Math.abs(dz) > 0) {
            int stepZ = dz > 0 ? 1 : -1;
            for (i = 1; i <= Math.abs(dz); ++i) {
                checkPos = zombiePos.m_7918_(0, 0, stepZ * i);
                for (int y = 0; y <= 2; ++y) {
                    pos = checkPos.m_6630_(y);
                    state = level.m_8055_(pos);
                    if (state.m_60795_() || !this.canBreakBlock(state.m_60734_())) continue;
                    return pos;
                }
            }
        }
        if (dy > 1) {
            for (int y = 1; y <= Math.min(dy, 5); ++y) {
                BlockPos checkPos2 = zombiePos.m_6630_(y);
                BlockState state = level.m_8055_(checkPos2);
                if (state.m_60795_() || !this.canBreakBlock(state.m_60734_())) continue;
                return checkPos2;
            }
        }
        return null;
    }

    private boolean isBlockingPath(BlockPos blockPos, BlockPos from, BlockPos to) {
        double minX = Math.min(from.m_123341_(), to.m_123341_()) - 1;
        double maxX = Math.max(from.m_123341_(), to.m_123341_()) + 1;
        double minZ = Math.min(from.m_123343_(), to.m_123343_()) - 1;
        double maxZ = Math.max(from.m_123343_(), to.m_123343_()) + 1;
        return (double)blockPos.m_123341_() >= minX && (double)blockPos.m_123341_() <= maxX && (double)blockPos.m_123343_() >= minZ && (double)blockPos.m_123343_() <= maxZ;
    }

    private boolean canBreakBlock(Block block) {
        return block != Blocks.f_50752_ && block != Blocks.f_50258_ && block != Blocks.f_50257_ && block != Blocks.f_50446_ && block != Blocks.f_50375_ && block != Blocks.f_50272_ && block != Blocks.f_50448_ && block != Blocks.f_50447_ && block != Blocks.f_50677_ && block != Blocks.f_50678_;
    }

    private int calculateBreakTime(BlockState blockState) {
        float hardness = blockState.m_60800_((BlockGetter)this.zombie.m_9236_(), this.targetBlockPos);
        if (hardness < 0.0f) {
            return Integer.MAX_VALUE;
        }
        boolean hasCorrectTool = this.hasPickaxe();
        float toolMultiplier = hasCorrectTool ? 6.0f : 1.0f;
        return (int)Math.ceil(hardness * 30.0f / toolMultiplier);
    }

    private boolean hasPickaxe() {
        ItemStack mainHand = this.zombie.m_21120_(InteractionHand.MAIN_HAND);
        return mainHand.m_41720_() == Items.f_42385_ || mainHand.m_41720_() == Items.f_42390_ || mainHand.m_41720_() == Items.f_42395_;
    }

    private void givePickaxe() {
        this.zombie.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42385_));
    }

    private boolean shouldBreakInsteadOfBuild() {
        if (this.zombie.m_5448_() == null) {
            return false;
        }
        Vec3 targetPos = this.zombie.m_5448_().m_20182_();
        Vec3 zombiePos = this.zombie.m_20182_();
        double horizontalDistance = Math.sqrt(Math.pow(targetPos.f_82479_ - zombiePos.f_82479_, 2.0) + Math.pow(targetPos.f_82481_ - zombiePos.f_82481_, 2.0));
        double verticalDistance = targetPos.f_82480_ - zombiePos.f_82480_;
        if (horizontalDistance <= 6.0 && Math.abs(verticalDistance) <= 2.0) {
            BlockPos zombieBlockPos = this.zombie.m_20183_();
            BlockPos targetBlockPos = this.zombie.m_5448_().m_20183_();
            int dx = targetBlockPos.m_123341_() - zombieBlockPos.m_123341_();
            int dz = targetBlockPos.m_123343_() - zombieBlockPos.m_123343_();
            int steps = Math.max(Math.abs(dx), Math.abs(dz));
            if (steps > 0) {
                for (int i = 1; i <= steps; ++i) {
                    int checkX = zombieBlockPos.m_123341_() + dx * i / steps;
                    int checkZ = zombieBlockPos.m_123343_() + dz * i / steps;
                    for (int y = 0; y <= 1; ++y) {
                        BlockPos checkPos = new BlockPos(checkX, zombieBlockPos.m_123342_() + y, checkZ);
                        BlockState state = this.zombie.m_9236_().m_8055_(checkPos);
                        if (state.m_60795_() || !this.canBreakBlock(state.m_60734_())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

