/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZombieBridgeGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Zombie zombie;
    private BlockPos currentBuildPos;
    private BlockPos targetBuildPos;
    private int buildingTime;
    private int stuckTime;
    private Vec3 lastPosition;
    private boolean needsScaffolding;
    private int scaffoldingHeight;
    private BuildMode currentMode = BuildMode.PILLAR_UP;

    public ZombieBridgeGoal(Zombie zombie) {
        this.zombie = zombie;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.zombie.m_5448_() == null || !this.zombie.m_5448_().m_6084_()) {
            return false;
        }
        Path pathToTarget = this.zombie.m_21573_().m_6570_((Entity)this.zombie.m_5448_(), 0);
        if (pathToTarget != null && pathToTarget.m_77403_()) {
            return false;
        }
        Vec3 targetPos = this.zombie.m_5448_().m_20182_();
        Vec3 zombiePos = this.zombie.m_20182_();
        double horizontalDistance = Math.sqrt(Math.pow(targetPos.f_82479_ - zombiePos.f_82479_, 2.0) + Math.pow(targetPos.f_82481_ - zombiePos.f_82481_, 2.0));
        double verticalDistance = targetPos.f_82480_ - zombiePos.f_82480_;
        return verticalDistance > 1.5 || horizontalDistance > 4.0 && Math.abs(verticalDistance) < 3.0;
    }

    public boolean m_8045_() {
        return this.zombie.m_5448_() != null && this.zombie.m_5448_().m_6084_() && !this.hasReachedTarget();
    }

    public void m_8056_() {
        this.buildingTime = 0;
        this.stuckTime = 0;
        this.lastPosition = this.zombie.m_20182_();
        this.scaffoldingHeight = 0;
        if (!this.hasBlocks()) {
            this.giveBlocks();
        }
        this.determineBuildMode();
        this.findNextBuildPosition();
    }

    public void m_8041_() {
        this.currentBuildPos = null;
        this.targetBuildPos = null;
        this.buildingTime = 0;
    }

    public void m_8037_() {
        Vec3 currentPos;
        if (this.currentBuildPos == null) {
            this.findNextBuildPosition();
            if (this.currentBuildPos == null) {
                return;
            }
        }
        if ((currentPos = this.zombie.m_20182_()).m_82554_(this.lastPosition) < 0.1) {
            ++this.stuckTime;
            if (this.stuckTime > 25) {
                this.needsScaffolding = true;
                this.findNextBuildPosition();
                this.stuckTime = 0;
            }
        } else {
            this.stuckTime = 0;
        }
        this.lastPosition = currentPos;
        Level level = this.zombie.m_9236_();
        this.zombie.m_21563_().m_24946_((double)this.currentBuildPos.m_123341_() + 0.5, (double)this.currentBuildPos.m_123342_() + 0.5, (double)this.currentBuildPos.m_123343_() + 0.5);
        double distance = this.zombie.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)this.currentBuildPos));
        if (distance > 2.5) {
            this.moveTowardsBuildPos();
            return;
        }
        ++this.buildingTime;
        this.zombie.m_6674_(InteractionHand.MAIN_HAND);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.buildingTime % 10 == 0) {
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50652_.m_49966_()), (double)this.currentBuildPos.m_123341_() + 0.5, (double)this.currentBuildPos.m_123342_() + 0.5, (double)this.currentBuildPos.m_123343_() + 0.5, 10, 0.3, 0.3, 0.3, 0.1);
            }
        }
        if (this.buildingTime >= 8) {
            if (this.canPlaceBlockAt(this.currentBuildPos)) {
                level.m_7731_(this.currentBuildPos, Blocks.f_50652_.m_49966_(), 3);
                level.m_5594_(null, this.currentBuildPos, SoundEvents.f_12447_, SoundSource.HOSTILE, 1.0f, 1.0f);
                if (this.currentMode == BuildMode.PILLAR_UP) {
                    BlockPos standPos = this.currentBuildPos.m_7494_();
                    if (level.m_8055_(standPos).m_60795_() && level.m_8055_(standPos.m_7494_()).m_60795_()) {
                        this.zombie.m_6034_((double)this.currentBuildPos.m_123341_() + 0.5, (double)(this.currentBuildPos.m_123342_() + 1), (double)this.currentBuildPos.m_123343_() + 0.5);
                        this.zombie.m_20334_(0.0, 0.2, 0.0);
                    }
                } else if (this.currentMode == BuildMode.BRIDGE_FORWARD) {
                    BlockPos movePos = this.zombie.m_20183_();
                    Vec3 targetDir = this.zombie.m_5448_().m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
                    if (this.shouldMoveForward()) {
                        this.zombie.m_21566_().m_6849_(this.zombie.m_20185_() + targetDir.f_82479_ * 0.5, this.zombie.m_20186_(), this.zombie.m_20189_() + targetDir.f_82481_ * 0.5, 1.0);
                    }
                }
            }
            this.buildingTime = 0;
            this.determineBuildMode();
            this.findNextBuildPosition();
        }
    }

    private void determineBuildMode() {
        if (this.zombie.m_5448_() == null) {
            return;
        }
        Vec3 targetPos = this.zombie.m_5448_().m_20182_();
        Vec3 zombiePos = this.zombie.m_20182_();
        double heightDiff = targetPos.f_82480_ - zombiePos.f_82480_;
        double horizontalDist = Math.sqrt(Math.pow(targetPos.f_82479_ - zombiePos.f_82479_, 2.0) + Math.pow(targetPos.f_82481_ - zombiePos.f_82481_, 2.0));
        this.currentMode = this.needsScaffolding || this.isHighUp() ? BuildMode.SCAFFOLD_SAFETY : (heightDiff > 2.0 ? BuildMode.PILLAR_UP : (horizontalDist > 2.0 ? BuildMode.BRIDGE_FORWARD : (heightDiff > 0.0 ? BuildMode.PILLAR_UP : BuildMode.BRIDGE_FORWARD)));
    }

    private void findNextBuildPosition() {
        if (this.zombie.m_5448_() == null) {
            return;
        }
        Level level = this.zombie.m_9236_();
        BlockPos zombiePos = this.zombie.m_20183_();
        BlockPos targetPos = this.zombie.m_5448_().m_20183_();
        switch (this.currentMode) {
            case PILLAR_UP: {
                Vec3 targetDirection = new Vec3((double)(targetPos.m_123341_() - zombiePos.m_123341_()), 0.0, (double)(targetPos.m_123343_() - zombiePos.m_123343_())).m_82541_();
                for (int y = 0; y <= 2; ++y) {
                    for (int step = 0; step <= 1; ++step) {
                        BlockPos checkPos = zombiePos.m_7918_((int)(targetDirection.f_82479_ * (double)step), y, (int)(targetDirection.f_82481_ * (double)step));
                        if (!this.canPlaceBlockAt(checkPos)) continue;
                        this.currentBuildPos = checkPos;
                        return;
                    }
                }
                break;
            }
            case BRIDGE_FORWARD: {
                float[] angles;
                Vec3 direction = new Vec3((double)(targetPos.m_123341_() - zombiePos.m_123341_()), 0.0, (double)(targetPos.m_123343_() - zombiePos.m_123343_())).m_82541_();
                for (float angleOffset : angles = new float[]{0.0f, 0.3f, -0.3f, 0.6f, -0.6f}) {
                    Vec3 adjustedDir = new Vec3(direction.f_82479_ * Math.cos(angleOffset) - direction.f_82481_ * Math.sin(angleOffset), 0.0, direction.f_82479_ * Math.sin(angleOffset) + direction.f_82481_ * Math.cos(angleOffset));
                    for (int dist = 1; dist <= 2; ++dist) {
                        for (int y = -1; y <= 0; ++y) {
                            BlockPos checkPos = zombiePos.m_7918_((int)(adjustedDir.f_82479_ * (double)dist), y, (int)(adjustedDir.f_82481_ * (double)dist));
                            if (!this.canPlaceBlockAt(checkPos) || !this.isSafeToBuild(checkPos)) continue;
                            this.currentBuildPos = checkPos;
                            return;
                        }
                    }
                }
                this.currentMode = BuildMode.SCAFFOLD_SAFETY;
                this.findNextBuildPosition();
                break;
            }
            case SCAFFOLD_SAFETY: {
                BlockPos[] safetyPositions;
                for (BlockPos checkPos : safetyPositions = new BlockPos[]{zombiePos.m_7495_(), zombiePos.m_122012_().m_7495_(), zombiePos.m_122019_().m_7495_(), zombiePos.m_122029_().m_7495_(), zombiePos.m_122024_().m_7495_(), zombiePos.m_6625_(2)}) {
                    if (!this.canPlaceBlockAt(checkPos)) continue;
                    this.currentBuildPos = checkPos;
                    this.needsScaffolding = false;
                    return;
                }
                break;
            }
        }
        this.currentBuildPos = null;
    }

    private boolean canPlaceBlockAt(BlockPos pos) {
        Level level = this.zombie.m_9236_();
        BlockState state = level.m_8055_(pos);
        return state.m_60795_() || state.m_247087_();
    }

    private boolean isSafeToBuild(BlockPos pos) {
        Level level = this.zombie.m_9236_();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos checkPos = pos.m_121945_(dir);
            if (level.m_8055_(checkPos.m_7495_()).m_60795_()) continue;
            return true;
        }
        return !level.m_8055_(pos.m_7495_()).m_60795_() || !level.m_8055_(pos.m_6625_(2)).m_60795_();
    }

    private boolean isHighUp() {
        Level level = this.zombie.m_9236_();
        BlockPos pos = this.zombie.m_20183_();
        for (int y = 1; y <= 5; ++y) {
            if (level.m_8055_(pos.m_6625_(y)).m_60795_()) continue;
            return false;
        }
        return true;
    }

    private boolean shouldMoveForward() {
        Level level = this.zombie.m_9236_();
        BlockPos zombiePos = this.zombie.m_20183_();
        Vec3 targetDir = this.zombie.m_5448_().m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
        BlockPos frontPos = zombiePos.m_7918_((int)targetDir.f_82479_, 0, (int)targetDir.f_82481_);
        return !level.m_8055_(frontPos.m_7495_()).m_60795_();
    }

    private void moveTowardsBuildPos() {
        if (this.currentBuildPos == null) {
            return;
        }
        double x = (double)this.currentBuildPos.m_123341_() + 0.5;
        double y = this.currentBuildPos.m_123342_();
        double z = (double)this.currentBuildPos.m_123343_() + 0.5;
        this.zombie.m_21573_().m_26519_(x, y, z, 1.0);
        if (this.zombie.m_20183_().m_123342_() < this.currentBuildPos.m_123342_() - 1) {
            this.zombie.m_20256_(this.zombie.m_20184_().m_82520_(0.0, 0.3, 0.0));
        }
    }

    private boolean hasReachedTarget() {
        if (this.zombie.m_5448_() == null) {
            return true;
        }
        double distance = this.zombie.m_20182_().m_82554_(this.zombie.m_5448_().m_20182_());
        return distance < 2.0;
    }

    private boolean hasBlocks() {
        ItemStack offHand = this.zombie.m_21120_(InteractionHand.OFF_HAND);
        return offHand.m_41720_() == Items.f_42594_ || offHand.m_41720_() == Items.f_42329_ || offHand.m_41720_() == Items.f_42048_;
    }

    private void giveBlocks() {
        this.zombie.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42594_, 64));
    }

    private static enum BuildMode {
        PILLAR_UP,
        BRIDGE_FORWARD,
        SCAFFOLD_SAFETY;

    }
}

