/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZombieOmniscienceGoal
extends TargetGoal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Zombie zombie;
    private final double detectionRadius;
    private Player targetPlayer;
    private int searchCooldown;
    private final TargetingConditions targetingConditions;

    public ZombieOmniscienceGoal(Zombie zombie, double detectionRadius) {
        super((Mob)zombie, false);
        this.zombie = zombie;
        this.detectionRadius = detectionRadius;
        this.searchCooldown = 0;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetingConditions = TargetingConditions.m_148352_().m_26883_(detectionRadius).m_148355_();
    }

    public boolean m_8036_() {
        if (this.searchCooldown > 0) {
            --this.searchCooldown;
            return false;
        }
        this.targetPlayer = this.findNearestPlayer();
        if (this.targetPlayer != null) {
            LOGGER.debug("Zombie {} detected player {} at distance {}", (Object)this.zombie.m_5446_().getString(), (Object)this.targetPlayer.m_5446_().getString(), (Object)this.zombie.m_20182_().m_82554_(this.targetPlayer.m_20182_()));
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.targetPlayer == null || !this.targetPlayer.m_6084_()) {
            return false;
        }
        double distance = this.zombie.m_20182_().m_82554_(this.targetPlayer.m_20182_());
        return !(distance > this.detectionRadius * 1.2);
    }

    public void m_8056_() {
        this.zombie.m_6710_((LivingEntity)this.targetPlayer);
        this.searchCooldown = 0;
        LOGGER.debug("Zombie {} started targeting player {}", (Object)this.zombie.m_5446_().getString(), (Object)this.targetPlayer.m_5446_().getString());
    }

    public void m_8041_() {
        this.targetPlayer = null;
        this.searchCooldown = 20;
    }

    public void m_8037_() {
        if (this.targetPlayer != null && this.zombie.m_5448_() != this.targetPlayer) {
            this.zombie.m_6710_((LivingEntity)this.targetPlayer);
        }
    }

    private Player findNearestPlayer() {
        AABB searchBox = new AABB(this.zombie.m_20185_() - this.detectionRadius, this.zombie.m_20186_() - this.detectionRadius, this.zombie.m_20189_() - this.detectionRadius, this.zombie.m_20185_() + this.detectionRadius, this.zombie.m_20186_() + this.detectionRadius, this.zombie.m_20189_() + this.detectionRadius);
        List nearbyPlayers = this.zombie.m_9236_().m_6443_(Player.class, searchBox, player -> player != null && player.m_6084_() && !player.m_5833_() && !player.m_7500_());
        Player closestPlayer = null;
        double closestDistance = Double.MAX_VALUE;
        for (Player player2 : nearbyPlayers) {
            double distance;
            if (!this.targetingConditions.m_26885_((LivingEntity)this.zombie, (LivingEntity)player2) || !((distance = this.zombie.m_20182_().m_82554_(player2.m_20182_())) < closestDistance)) continue;
            closestDistance = distance;
            closestPlayer = player2;
        }
        return closestPlayer;
    }
}

