/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZombiePillarGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Zombie zombie;
    private BlockPos buildPos;
    private int buildingTime;
    private int buildCooldown;
    private boolean jumping;
    private int jumpAttempts;

    public ZombiePillarGoal(Zombie zombie) {
        this.zombie = zombie;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        BlockPos potentialBuildPos;
        if (this.zombie.m_5448_() == null || !this.zombie.m_5448_().m_6084_() || this.buildCooldown > 0) {
            return false;
        }
        PathNavigation navigation = this.zombie.m_21573_();
        Path pathToTarget = navigation.m_6570_((Entity)this.zombie.m_5448_(), 0);
        if (pathToTarget != null && pathToTarget.m_77403_()) {
            return false;
        }
        Vec3 targetPos = this.zombie.m_5448_().m_20182_();
        Vec3 zombiePos = this.zombie.m_20182_();
        double horizontalDistance = Math.sqrt(Math.pow(targetPos.f_82479_ - zombiePos.f_82479_, 2.0) + Math.pow(targetPos.f_82481_ - zombiePos.f_82481_, 2.0));
        if (horizontalDistance > 16.0) {
            return false;
        }
        int targetY = (int)targetPos.f_82480_;
        int zombieY = (int)zombiePos.f_82480_;
        if (targetY > zombieY + 1 && horizontalDistance <= 6.0 && (potentialBuildPos = this.findBuildPosition()) != null) {
            this.buildPos = potentialBuildPos;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.buildPos != null && this.zombie.m_5448_() != null && this.zombie.m_5448_().m_6084_() && this.zombie.m_20186_() < this.zombie.m_5448_().m_20186_() + 2.0;
    }

    public void m_8056_() {
        this.buildingTime = 0;
        this.jumping = false;
        this.jumpAttempts = 0;
        if (!this.hasBlocks()) {
            this.giveBlocks();
        }
        LOGGER.debug("Zombie starting to build at {}", (Object)this.buildPos);
    }

    public void m_8041_() {
        this.buildPos = null;
        this.buildingTime = 0;
        this.buildCooldown = 40;
        this.jumping = false;
    }

    public void m_8037_() {
        if (this.buildCooldown > 0) {
            --this.buildCooldown;
            return;
        }
        if (this.buildPos == null) {
            return;
        }
        Level level = this.zombie.m_9236_();
        this.zombie.m_21563_().m_24946_((double)this.buildPos.m_123341_() + 0.5, (double)this.buildPos.m_123342_() + 0.5, (double)this.buildPos.m_123343_() + 0.5);
        double distance = this.zombie.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)this.buildPos));
        if (distance > 2.0) {
            if (!this.zombie.m_21573_().m_26519_((double)this.buildPos.m_123341_() + 0.5, (double)this.buildPos.m_123342_(), (double)this.buildPos.m_123343_() + 0.5, 1.2)) {
                this.buildPos = this.findBuildPosition();
            }
            return;
        }
        if (!this.jumping) {
            ++this.buildingTime;
            this.zombie.m_6674_(InteractionHand.MAIN_HAND);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.buildingTime % 10 == 0) {
                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50652_.m_49966_()), (double)this.buildPos.m_123341_() + 0.5, (double)this.buildPos.m_123342_() + 0.5, (double)this.buildPos.m_123343_() + 0.5, 10, 0.3, 0.3, 0.3, 0.1);
                }
            }
            if (this.buildingTime >= 10 && (level.m_8055_(this.buildPos).m_60795_() || level.m_8055_(this.buildPos).m_247087_())) {
                level.m_7731_(this.buildPos, Blocks.f_50652_.m_49966_(), 3);
                level.m_5594_(null, this.buildPos, SoundEvents.f_12447_, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.jumping = true;
                this.buildingTime = 0;
            }
        } else {
            ++this.jumpAttempts;
            if (this.jumpAttempts > 10) {
                BlockPos zombiePos = this.zombie.m_20183_();
                if (zombiePos.m_123342_() <= this.buildPos.m_123342_()) {
                    this.zombie.m_20256_(this.zombie.m_20184_().m_82520_(0.0, 0.42, 0.0));
                }
                if (zombiePos.m_123342_() > this.buildPos.m_123342_() || this.jumpAttempts > 40) {
                    this.jumping = false;
                    this.jumpAttempts = 0;
                    this.buildPos = this.findNextBuildPosition();
                    if (this.buildPos == null) {
                        this.m_8041_();
                    }
                }
            }
        }
    }

    private BlockPos findBuildPosition() {
        if (this.zombie.m_5448_() == null) {
            return null;
        }
        Level level = this.zombie.m_9236_();
        BlockPos zombiePos = this.zombie.m_20183_();
        BlockPos targetPos = this.zombie.m_5448_().m_20183_();
        int dx = targetPos.m_123341_() - zombiePos.m_123341_();
        int dz = targetPos.m_123343_() - zombiePos.m_123343_();
        double angle = Math.atan2(dz, dx);
        for (int distance = 1; distance <= 3; ++distance) {
            int checkX = zombiePos.m_123341_() + (int)(Math.cos(angle) * (double)distance);
            int checkZ = zombiePos.m_123343_() + (int)(Math.sin(angle) * (double)distance);
            for (int y = -1; y <= 1; ++y) {
                BlockPos belowPos;
                BlockPos checkPos = new BlockPos(checkX, zombiePos.m_123342_() + y, checkZ);
                if (!this.canBuildAt(checkPos)) continue;
                if (y == -1 && level.m_8055_(belowPos = checkPos.m_7495_()).m_60795_()) {
                    level.m_7731_(belowPos, Blocks.f_50652_.m_49966_(), 3);
                }
                return checkPos;
            }
        }
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos checkPos;
                if (Math.abs(x) + Math.abs(z) > 2 || x == 0 && z == 0 || !this.canBuildAt(checkPos = zombiePos.m_7918_(x, 0, z))) continue;
                return checkPos;
            }
        }
        return null;
    }

    private BlockPos findNextBuildPosition() {
        if (this.zombie.m_5448_() == null) {
            return null;
        }
        BlockPos currentPos = this.zombie.m_20183_();
        int targetY = this.zombie.m_5448_().m_20183_().m_123342_();
        if (currentPos.m_123342_() >= targetY + 1) {
            return null;
        }
        return this.findBuildPosition();
    }

    private boolean canBuildAt(BlockPos pos) {
        Level level = this.zombie.m_9236_();
        BlockState state = level.m_8055_(pos);
        BlockState below = level.m_8055_(pos.m_7495_());
        BlockState above = level.m_8055_(pos.m_7494_());
        return (state.m_60795_() || state.m_247087_()) && !below.m_60795_() && above.m_60795_();
    }

    private boolean hasBlocks() {
        ItemStack offHand = this.zombie.m_21120_(InteractionHand.OFF_HAND);
        return offHand.m_41720_() == Items.f_42594_ || offHand.m_41720_() == Items.f_42329_ || offHand.m_41720_() == Items.f_42048_;
    }

    private void giveBlocks() {
        this.zombie.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42594_, 64));
    }
}

