/*
 * Decompiled with CFR 0.152.
 */
package com.smartmobs.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class SmartMobsConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ZOMBIE_BLOCK_BREAKING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ZOMBIE_BRIDGE_BUILDING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ZOMBIE_PILLAR_BUILDING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ZOMBIE_OMNISCIENCE;
    public static final ForgeConfigSpec.ConfigValue<Double> ZOMBIE_OMNISCIENCE_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SKELETON_SNIPER_AI;
    public static final ForgeConfigSpec.ConfigValue<Double> SKELETON_SNIPER_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Double> SKELETON_ACCURACY_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SPIDER_WEB_ATTACKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CREEPER_WALL_EXPLOSION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CREEPER_PRE_POWERED;
    public static final ForgeConfigSpec.ConfigValue<Double> CREEPER_PRE_POWERED_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CREEPER_NAPALM_EXPLOSION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CREEPER_OMNISCIENCE;
    public static final ForgeConfigSpec.ConfigValue<Double> CREEPER_OMNISCIENCE_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENDERMAN_TELEPORT_PLAYER;
    public static final ForgeConfigSpec.ConfigValue<Double> ENDERMAN_TELEPORT_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Integer> ENDERMAN_TELEPORT_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<Double> ENDERMAN_TELEPORT_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENDERMAN_SLENDER_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<Double> ENDERMAN_SLENDER_RANGE;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "smartmobs-common.toml");
    }

    static {
        BUILDER.comment("Smart Mobs Configuration").push("smartmobs");
        BUILDER.comment("Zombie AI Enhancements").push("zombie");
        ZOMBIE_BLOCK_BREAKING = BUILDER.comment("Enable zombies to break blocks when blocked by obstacles").define("blockBreaking", true);
        ZOMBIE_BRIDGE_BUILDING = BUILDER.comment("Enable zombies to build bridges across gaps").define("bridgeBuilding", true);
        ZOMBIE_PILLAR_BUILDING = BUILDER.comment("Enable zombies to build pillars to reach higher targets").define("pillarBuilding", true);
        ZOMBIE_OMNISCIENCE = BUILDER.comment("Enable zombies to track players through walls").define("omniscience", true);
        ZOMBIE_OMNISCIENCE_RANGE = BUILDER.comment("Range for zombie omniscience ability").defineInRange("omniscienceRange", 32.0, 1.0, 128.0);
        BUILDER.pop();
        BUILDER.comment("Skeleton AI Enhancements").push("skeleton");
        SKELETON_SNIPER_AI = BUILDER.comment("Enable enhanced skeleton accuracy and range").define("sniperAI", true);
        SKELETON_SNIPER_RANGE = BUILDER.comment("Enhanced range for skeleton attacks").defineInRange("sniperRange", 32.0, 8.0, 64.0);
        SKELETON_ACCURACY_MULTIPLIER = BUILDER.comment("Accuracy multiplier for skeleton shots").defineInRange("accuracyMultiplier", 2.0, 1.0, 5.0);
        BUILDER.pop();
        BUILDER.comment("Spider AI Enhancements").push("spider");
        SPIDER_WEB_ATTACKS = BUILDER.comment("Enable spiders to use web attacks").define("webAttacks", true);
        BUILDER.pop();
        BUILDER.comment("Creeper AI Enhancements").push("creeper");
        CREEPER_WALL_EXPLOSION = BUILDER.comment("Enable creepers to explode at walls when blocked").define("wallExplosion", true);
        CREEPER_PRE_POWERED = BUILDER.comment("Enable creepers to spawn pre-powered (charged)").define("prePowered", true);
        CREEPER_PRE_POWERED_CHANCE = BUILDER.comment("Chance for creepers to spawn pre-powered").defineInRange("prePoweredChance", 0.15, 0.0, 1.0);
        CREEPER_NAPALM_EXPLOSION = BUILDER.comment("Enable creeper explosions to leave fire/napalm effects").define("napalmExplosion", true);
        CREEPER_OMNISCIENCE = BUILDER.comment("Enable creepers to track players through walls").define("omniscience", true);
        CREEPER_OMNISCIENCE_RANGE = BUILDER.comment("Range for creeper omniscience ability").defineInRange("omniscienceRange", 32.0, 1.0, 128.0);
        BUILDER.pop();
        BUILDER.comment("Enderman AI Enhancements").push("enderman");
        ENDERMAN_TELEPORT_PLAYER = BUILDER.comment("Enable endermen to teleport players they are attacking").define("teleportPlayer", true);
        ENDERMAN_TELEPORT_CHANCE = BUILDER.comment("Chance for endermen to teleport players during combat").defineInRange("teleportChance", 0.15, 0.0, 1.0);
        ENDERMAN_TELEPORT_COOLDOWN = BUILDER.comment("Cooldown between player teleportations (in ticks)").defineInRange("teleportCooldown", 600, 60, 6000);
        ENDERMAN_TELEPORT_RANGE = BUILDER.comment("Range for enderman player teleportation").defineInRange("teleportRange", 64.0, 8.0, 128.0);
        ENDERMAN_SLENDER_EFFECTS = BUILDER.comment("Enable Slenderman-like effects for endermen").define("slenderEffects", true);
        ENDERMAN_SLENDER_RANGE = BUILDER.comment("Range for enderman Slenderman effects").defineInRange("slenderRange", 32.0, 8.0, 64.0);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

