/*
 * Decompiled with CFR 0.152.
 */
package com.cui.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import dev.architectury.platform.Platform;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Random;

public class CUI_Config {
    public float a;
    public float r;
    public float g;
    public float b;
    private CommentedFileConfig fileConfig;

    public void loadConfig() throws IOException {
        Path cp = Platform.getConfigFolder();
        Path c = cp.resolve("cui_config.toml");
        if (Files.exists(c, new LinkOption[0])) {
            Optional alpha;
            this.fileConfig = (CommentedFileConfig)CommentedFileConfig.builder(c).concurrent().build();
            this.fileConfig.load();
            System.out.println("EXISTS");
            Optional rgb = this.fileConfig.getOptional("color");
            if (rgb.isPresent()) {
                try {
                    String hex = (String)rgb.get();
                    this.r = (float)Integer.valueOf(hex.substring(0, 2), 16).intValue() / 255.0f;
                    this.g = (float)Integer.valueOf(hex.substring(2, 4), 16).intValue() / 255.0f;
                    this.b = (float)Integer.valueOf(hex.substring(4, 6), 16).intValue() / 255.0f;
                }
                catch (Exception e) {
                    System.err.println("CUI Config: Invalid color format, using defaults.");
                    Color defaultColor = CUI_Config.randomPastel();
                    this.r = (float)defaultColor.getRed() / 255.0f;
                    this.g = (float)defaultColor.getGreen() / 255.0f;
                    this.b = (float)defaultColor.getBlue() / 255.0f;
                }
            }
            this.a = (alpha = this.fileConfig.getOptional("alpha")).isPresent() ? ((Double)alpha.get()).floatValue() : 0.75f;
            System.out.println(this.r);
            System.out.println(this.g);
            System.out.println(this.b);
            System.out.println(this.a);
        } else {
            System.out.println("NOT EXISTS");
            Color color = CUI_Config.randomPastel();
            this.r = (float)color.getRed() / 255.0f;
            this.g = (float)color.getGreen() / 255.0f;
            this.b = (float)color.getBlue() / 255.0f;
            this.a = (float)color.getAlpha() / 255.0f;
        }
    }

    public void saveConfig() {
        Path c = Platform.getConfigFolder().resolve("cui_config.toml");
        try {
            String hexColor = String.format("%02X%02X%02X", (int)(this.r * 255.0f), (int)(this.g * 255.0f), (int)(this.b * 255.0f));
            try (BufferedWriter writer = Files.newBufferedWriter(c, new OpenOption[0]);){
                writer.write("# CUI config\n");
                writer.write("color = \"" + hexColor + "\"\n");
                writer.write("alpha = " + this.a);
            }
            System.out.println("Config saved to " + String.valueOf(c.toAbsolutePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Color randomPastel() {
        Random random = new Random();
        int r = random.nextInt(50, 201);
        int g = random.nextInt(50, 201);
        int b = random.nextInt(50, 201);
        return new Color(r, g, b, 191);
    }
}

