/*
 * Decompiled with CFR 0.152.
 */
package com.cui.abs.core.data;

import com.cui.abs.core.data.Pair;
import org.jetbrains.annotations.NotNull;

public class TextureRectangle {
    public Pair<Float, Float> position;
    public Pair<Integer, Integer> dimensions;

    public TextureRectangle(@NotNull Pair<Float, Float> position, @NotNull Pair<Integer, Integer> dimensions) {
        this.position = position;
        this.dimensions = dimensions;
    }

    public TextureRectangle(float x, float y, int width, int height) {
        this.position = new Pair<Float, Float>(Float.valueOf(x), Float.valueOf(y));
        this.dimensions = new Pair<Integer, Integer>(width, height);
    }

    public TextureRectangle(@NotNull Pair<Float, Float> position, int width, int height) {
        this.position = position;
        this.dimensions = new Pair<Integer, Integer>(width, height);
    }

    public TextureRectangle(float x, float y, @NotNull Pair<Integer, Integer> dimensions) {
        this.position = new Pair<Float, Float>(Float.valueOf(x), Float.valueOf(y));
        this.dimensions = dimensions;
    }

    public boolean isPositionFilled() {
        return this.position != null && this.position.isFilled();
    }

    public boolean isDimensionsFilled() {
        return this.dimensions != null && this.dimensions.isFilled();
    }

    public boolean isFilled() {
        return this.isPositionFilled() && this.isDimensionsFilled();
    }

    public boolean isEmpty() {
        return !this.isPositionFilled() && !this.isDimensionsFilled();
    }
}

