/*
 * Decompiled with CFR 0.152.
 */
package com.cui.abs.core.rendering.gui;

import com.cui.abs.core.data.Rectangle;
import com.cui.abs.core.mixin.rendering.gui.GuiGraphicsAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiRenderer {
    static boolean warned = false;

    public static GuiSpriteScaling getSpriteScaling(GuiGraphics guiGraphics, ResourceLocation sprite) {
        TextureAtlasSprite textureAtlasSprite = ((GuiGraphicsAccessor)guiGraphics).getGuiSprites().getSprite(sprite);
        return ((GuiGraphicsAccessor)guiGraphics).getGuiSprites().getSpriteScaling(textureAtlasSprite);
    }

    @Nullable
    public static GuiSpriteScaling.Tile getSpriteTile(GuiGraphics guiGraphics, ResourceLocation sprite) {
        TextureAtlasSprite textureAtlasSprite = ((GuiGraphicsAccessor)guiGraphics).getGuiSprites().getSprite(sprite);
        return GuiRenderer.getSpriteTile(guiGraphics, textureAtlasSprite);
    }

    @Nullable
    public static GuiSpriteScaling.Tile getSpriteTile(GuiGraphics guiGraphics, TextureAtlasSprite textureAtlasSprite) {
        GuiSpriteScaling spriteScaling = ((GuiGraphicsAccessor)guiGraphics).getGuiSprites().getSpriteScaling(textureAtlasSprite);
        Objects.requireNonNull(spriteScaling);
        return spriteScaling.type() == GuiSpriteScaling.Type.TILE ? (GuiSpriteScaling.Tile)spriteScaling : null;
    }

    protected static Dimensions getSpriteContentsDimensions(GuiGraphics guiGraphics, ResourceLocation sprite) {
        TextureAtlasSprite textureAtlasSprite = ((GuiGraphicsAccessor)guiGraphics).getGuiSprites().getSprite(sprite);
        return GuiRenderer.getSpriteContentsDimensions(guiGraphics, textureAtlasSprite);
    }

    public static Dimensions getSpriteContentsDimensions(GuiGraphics guiGraphics, TextureAtlasSprite textureAtlasSprite) {
        GuiSpriteScaling.Tile spriteTile = GuiRenderer.getSpriteTile(guiGraphics, textureAtlasSprite);
        return new Dimensions(spriteTile != null ? spriteTile.width() : textureAtlasSprite.contents().width(), spriteTile != null ? spriteTile.height() : textureAtlasSprite.contents().height());
    }

    protected static Dimensions getTextureDimensions(GuiGraphics guiGraphics, ResourceLocation sprite, Dimensions spriteDimensions) {
        TextureAtlasSprite textureAtlasSprite = ((GuiGraphicsAccessor)guiGraphics).getGuiSprites().getSprite(sprite);
        return GuiRenderer.getTextureDimensions(guiGraphics, textureAtlasSprite, spriteDimensions);
    }

    public static Dimensions getTextureDimensions(GuiGraphics guiGraphics, TextureAtlasSprite textureAtlasSprite, Dimensions spriteDimensions) {
        Dimensions spriteContentsDimensions = GuiRenderer.getSpriteContentsDimensions(guiGraphics, textureAtlasSprite);
        return new Dimensions((int)((float)spriteDimensions.width / (float)spriteContentsDimensions.width * (float)spriteContentsDimensions.width + 0.9f), (int)((float)spriteDimensions.height / (float)spriteContentsDimensions.height * (float)spriteContentsDimensions.height + 0.9f));
    }

    public static void setShaderColor(GuiGraphics guiGraphics, float red, float green, float blue, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        guiGraphics.flush();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    public static void setShaderColor(GuiGraphics guiGraphics, int color) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        guiGraphics.flush();
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    public static void setShaderAlpha(GuiGraphics guiGraphics, int alpha) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        guiGraphics.flush();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    public static void clearShaderColor(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        guiGraphics.flush();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    public static void blitSprite(GuiGraphics guiGraphics, String pipeline, ResourceLocation sprite, @NotNull Rectangle blitRectangle, @NotNull Rectangle textureRectangle) {
        GuiRenderer.blitSprite(guiGraphics, pipeline, sprite, blitRectangle, textureRectangle, null);
    }

    public static void blitSprite(GuiGraphics guiGraphics, String pipeline, ResourceLocation sprite, @NotNull Rectangle blitRectangle, @NotNull Rectangle textureRectangle, @Nullable Integer color) {
        if (blitRectangle.isEmpty()) {
            throw new RuntimeException("blitRectangle position/dimensions is not provided");
        }
        int x = (Integer)blitRectangle.position.first;
        int y = (Integer)blitRectangle.position.second;
        if (!blitRectangle.isDimensionsFilled()) {
            int u = (Integer)textureRectangle.position.first;
            int v = (Integer)textureRectangle.position.second;
            int textureWidth = (Integer)textureRectangle.dimensions.first;
            int textureHeight = (Integer)textureRectangle.dimensions.second;
            GuiRenderer.blitSprite(guiGraphics, sprite, u, v, textureWidth, textureHeight, x, y, color);
        }
        int width = (Integer)blitRectangle.dimensions.first;
        int height = (Integer)blitRectangle.dimensions.second;
        if (textureRectangle.isPositionFilled()) {
            int u = (Integer)textureRectangle.position.first;
            int v = (Integer)textureRectangle.position.second;
            if (textureRectangle.isDimensionsFilled()) {
                int textureWidth = (Integer)textureRectangle.dimensions.first;
                int textureHeight = (Integer)textureRectangle.dimensions.second;
                GuiRenderer.blitSprite(guiGraphics, sprite, u, v, textureWidth, textureHeight, x, y, width, height, color);
            } else {
                GuiRenderer.blitSprite(guiGraphics, sprite, u, v, x, y, width, height, color);
            }
        } else {
            throw new RuntimeException("textureRectangle UV is empty");
        }
    }

    public static void blitSprite(GuiGraphics guiGraphics, String pipeline, ResourceLocation sprite, @NotNull Rectangle blitRectangle) {
        GuiRenderer.blitSprite(guiGraphics, pipeline, sprite, blitRectangle, (Integer)null);
    }

    public static void blitSprite(GuiGraphics guiGraphics, String pipeline, ResourceLocation sprite, @NotNull Rectangle blitRectangle, @Nullable Integer color) {
        if (!blitRectangle.isPositionFilled()) {
            throw new RuntimeException("blitRectangle position is not provided");
        }
        int x = (Integer)blitRectangle.position.first;
        int y = (Integer)blitRectangle.position.second;
        if (blitRectangle.isDimensionsFilled()) {
            int width = (Integer)blitRectangle.dimensions.first;
            int height = (Integer)blitRectangle.dimensions.second;
            GuiRenderer.blitSprite(guiGraphics, sprite, x, y, width, height, color);
        } else {
            GuiRenderer.blitSprite(guiGraphics, sprite, x, y, color);
        }
    }

    private static void blitSpriteAbstract(GuiGraphics guiGraphics, @Nullable Integer color, Runnable action) {
        if (color != null) {
            GuiRenderer.setShaderColor(guiGraphics, color);
            action.run();
            GuiRenderer.clearShaderColor(guiGraphics);
        } else {
            action.run();
        }
    }

    protected static void blitSprite(GuiGraphics guiGraphics, ResourceLocation sprite, int x, int y, @Nullable Integer color) {
        Dimensions spriteDimensions = GuiRenderer.getSpriteContentsDimensions(guiGraphics, sprite);
        GuiRenderer.blitSpriteAbstract(guiGraphics, color, () -> guiGraphics.blitSprite(sprite, x, y, spriteDimensions.width, spriteDimensions.height));
    }

    protected static void blitSprite(GuiGraphics guiGraphics, ResourceLocation sprite, int x, int y, int width, int height, @Nullable Integer color) {
        GuiRenderer.blitSpriteAbstract(guiGraphics, color, () -> guiGraphics.blitSprite(sprite, x, y, width, height));
    }

    protected static void blitSprite(GuiGraphics guiGraphics, ResourceLocation sprite, int u, int v, int x, int y, int width, int height, @Nullable Integer color) {
        Dimensions textureDimensions = GuiRenderer.getTextureDimensions(guiGraphics, sprite, new Dimensions(width, height));
        GuiRenderer.blitSpriteAbstract(guiGraphics, color, () -> guiGraphics.blitSprite(sprite, textureDimensions.width, textureDimensions.height, u, v, x, y, width, height));
    }

    protected static void blitSprite(GuiGraphics guiGraphics, ResourceLocation sprite, int u, int v, int textureWidth, int textureHeight, int x, int y, int width, int height, @Nullable Integer color) {
        GuiRenderer.blitSpriteAbstract(guiGraphics, color, () -> guiGraphics.blitSprite(sprite, textureWidth, textureHeight, u, v, x, y, width, height));
    }

    public record Dimensions(int width, int height) {
    }
}

