/*
 * Decompiled with CFR 0.152.
 */
package com.cui.core.config;

import com.cui.core.CUI;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import dev.architectury.platform.Platform;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Random;

public class CUI_Config {
    public float a;
    public float r;
    public float g;
    public float b;
    public float desaturation;
    public boolean enableButton;
    public Color color;

    public void loadConfig() throws IOException {
        Path cp = Platform.getConfigFolder();
        Path c = cp.resolve("cui_config.toml");
        if (Files.exists(c, new LinkOption[0])) {
            CommentedFileConfig fileConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)c).concurrent().build();
            fileConfig.load();
            System.out.println("CUI CONFIG EXISTS");
            Optional rgb = fileConfig.getOptional("color");
            Optional alpha = fileConfig.getOptional("alpha");
            Optional enableButton = fileConfig.getOptional("button");
            Optional desaturation = fileConfig.getOptional("desaturation");
            this.color = CUI_Config.randomPastel();
            boolean brokenConfig = false;
            try {
                this.r = rgb.map(hex -> Float.valueOf((float)Integer.parseInt(hex.substring(0, 2), 16) / 255.0f)).orElse(Float.valueOf(1.0f)).floatValue();
            }
            catch (Exception exception) {
                this.r = (float)this.color.getRed() / 255.0f;
                brokenConfig = true;
                CUI.LOGGER.info(exception.getMessage());
            }
            try {
                this.g = rgb.map(hex -> Float.valueOf((float)Integer.parseInt(hex.substring(2, 4), 16) / 255.0f)).orElse(Float.valueOf(1.0f)).floatValue();
            }
            catch (Exception exception) {
                this.g = (float)this.color.getGreen() / 255.0f;
                brokenConfig = true;
                CUI.LOGGER.info(exception.getMessage());
            }
            try {
                this.b = rgb.map(hex -> Float.valueOf((float)Integer.parseInt(hex.substring(4, 6), 16) / 255.0f)).orElse(Float.valueOf(1.0f)).floatValue();
            }
            catch (Exception exception) {
                this.b = (float)this.color.getBlue() / 255.0f;
                brokenConfig = true;
                CUI.LOGGER.info(exception.getMessage());
            }
            try {
                this.a = alpha.map(Float::parseFloat).orElse(Float.valueOf(1.0f)).floatValue();
            }
            catch (Exception exception) {
                this.a = (float)this.color.getAlpha() / 255.0f;
                brokenConfig = true;
                CUI.LOGGER.info(exception.getMessage());
            }
            try {
                this.enableButton = enableButton.map(Boolean::parseBoolean).orElse(true);
            }
            catch (Exception exception) {
                this.enableButton = true;
                brokenConfig = true;
                CUI.LOGGER.info(exception.getMessage());
            }
            try {
                this.desaturation = desaturation.map(Float::parseFloat).orElse(Float.valueOf(1.5f)).floatValue();
            }
            catch (Exception exception) {
                this.desaturation = 1.5f;
                brokenConfig = true;
                CUI.LOGGER.info(exception.getMessage());
            }
            if (brokenConfig) {
                this.saveConfig();
            }
            this.color = new Color(this.r, this.g, this.b, this.a);
        } else {
            System.out.println("CUI CONFIG NOT EXISTS");
            this.color = CUI_Config.randomPastel();
            this.r = (float)this.color.getRed() / 255.0f;
            this.g = (float)this.color.getGreen() / 255.0f;
            this.b = (float)this.color.getBlue() / 255.0f;
            this.a = (float)this.color.getAlpha() / 255.0f;
            this.enableButton = true;
            this.desaturation = 1.5f;
        }
    }

    public void saveConfig() {
        Path c = Platform.getConfigFolder().resolve("cui_config.toml");
        try {
            String hexColor = String.format("%02X%02X%02X", (int)(this.r * 255.0f), (int)(this.g * 255.0f), (int)(this.b * 255.0f));
            try (BufferedWriter writer = Files.newBufferedWriter(c, new OpenOption[0]);){
                writer.write("# CUI config\n");
                writer.write("color = \"" + hexColor + "\"\n");
                writer.write("alpha = \"" + this.a + "\"\n");
                writer.write("desaturation = \"" + this.desaturation + "\"\n");
                writer.write("button = \"" + this.enableButton + "\"\n");
            }
            System.out.println("Config saved to " + String.valueOf(c.toAbsolutePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Color randomPastel() {
        Random random = new Random();
        int r = random.nextInt(50, 201);
        int g = random.nextInt(50, 201);
        int b = random.nextInt(50, 201);
        return new Color(r, g, b, 191);
    }

    public int getRGB() {
        return 0xFF000000 | this.color.getRed() << 16 | this.color.getGreen() << 8 | this.color.getBlue();
    }

    public int getRGBA() {
        return this.color.getAlpha() << 24 | this.color.getRed() << 16 | this.color.getGreen() << 8 | this.color.getBlue();
    }

    public int getRGBA(float alpha) {
        return (int)(alpha * 255.0f) << 24 | this.color.getRed() << 16 | this.color.getGreen() << 8 | this.color.getBlue();
    }

    public float[] getHSV() {
        return Color.RGBtoHSB((int)(CUI.cuiConfig.r * 255.0f), (int)(CUI.cuiConfig.g * 255.0f), (int)(CUI.cuiConfig.b * 255.0f), null);
    }

    public int getTextColor(int originalColor) {
        float[] hsv = Color.RGBtoHSB((int)(CUI.cuiConfig.r * 255.0f), (int)(CUI.cuiConfig.g * 255.0f), (int)(CUI.cuiConfig.b * 255.0f), null);
        float avg = (float)((originalColor & 0xFF) + (originalColor >> 8 & 0xFF) + (originalColor >> 16 & 0xFF)) / 3.0f;
        return Color.getHSBColor(hsv[0], hsv[1] / this.desaturation, avg / 255.0f).getRGB() & 0xFFFFFF | (originalColor >> 24 & 0xFF) << 24;
    }

    public int getTextColor(int originalColor, float alpha) {
        float[] hsv = Color.RGBtoHSB((int)(CUI.cuiConfig.r * 255.0f), (int)(CUI.cuiConfig.g * 255.0f), (int)(CUI.cuiConfig.b * 255.0f), null);
        float avg = (float)((originalColor & 0xFF) + (originalColor >> 8 & 0xFF) + (originalColor >> 16 & 0xFF)) / 3.0f;
        int a = (int)(alpha * 255.0f) & 0xFF;
        return Color.getHSBColor(hsv[0], hsv[1] / this.desaturation, avg / 255.0f).getRGB() & 0xFFFFFF | a << 24;
    }

    public boolean isDark() {
        return this.r + this.g + this.b <= 1.5f;
    }

    public int getRGBfromValue(float value) {
        float[] hsv = this.getHSV();
        Color color = Color.getHSBColor(hsv[0], hsv[1], value);
        return color.getRGB();
    }

    public float getValue() {
        return (this.r + this.g + this.b) / 3.0f;
    }

    public int getThemeColor() {
        return this.isDark() ? this.getRGBfromValue(1.0f - this.getValue()) : this.getRGBfromValue(this.getValue());
    }
}

