/*
 * Decompiled with CFR 0.152.
 */
package com.cui.mixin.client.screen.misc;

import com.cui.abs.core.rendering.gui.GuiRenderer;
import com.cui.core.CUI;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Screen.class})
public abstract class ScreenMixin {
    @Shadow
    public int width;
    @Shadow
    public int height;

    @Inject(at={@At(value="HEAD")}, method={"renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"})
    private void renderHead1(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        GuiRenderer.setShaderColor(guiGraphics, CUI.cuiConfig.getRGB());
    }

    @Inject(at={@At(value="TAIL")}, method={"renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"})
    private void renderTail1(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        GuiRenderer.clearShaderColor(guiGraphics);
    }

    @Inject(at={@At(value="TAIL")}, method={"renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"})
    private void render1(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        float[] hsv = Color.RGBtoHSB((int)(CUI.cuiConfig.r * 255.0f), (int)(CUI.cuiConfig.g * 255.0f), (int)(CUI.cuiConfig.b * 255.0f), null);
        guiGraphics.fillGradient(0, 0, this.width, this.height, (int)(CUI.cuiConfig.a * 255.0f) << 24 | Color.getHSBColor(hsv[0], hsv[1], hsv[2] / 2.7f).getRGB() & 0xFFFFFF, (int)(CUI.cuiConfig.a * 255.0f) << 24 | Color.getHSBColor(hsv[0], hsv[1], hsv[2] / 5.0f).getRGB() & 0xFFFFFF);
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"renderTransparentBackground(Lnet/minecraft/client/gui/GuiGraphics;)V"})
    private void render2(GuiGraphics guiGraphics, CallbackInfo ci) {
        float[] hsv = CUI.cuiConfig.getHSV();
        guiGraphics.fillGradient(0, 0, this.width, this.height, (int)(CUI.cuiConfig.a * 255.0f) << 24 | Color.getHSBColor(hsv[0], hsv[1], hsv[2] / 2.7f).getRGB() & 0xFFFFFF, (int)(CUI.cuiConfig.a * 255.0f) << 24 | Color.getHSBColor(hsv[0], hsv[1], hsv[2] / 5.0f).getRGB() & 0xFFFFFF);
        ci.cancel();
    }
}

