/*
 * Decompiled with CFR 0.152.
 */
package com.cui;

import com.cui.CUI;
import java.awt.Color;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ColorScreen
extends Screen {
    private final Screen parent;
    private float h;
    private float s;
    private float v;
    private float a;

    public ColorScreen(Screen parent) {
        super((Component)Component.literal((String)"Color Config (HSV + Alpha)"));
        this.parent = parent;
        float[] hsv = Color.RGBtoHSB((int)(CUI.cuiConfig.r * 255.0f), (int)(CUI.cuiConfig.g * 255.0f), (int)(CUI.cuiConfig.b * 255.0f), null);
        this.h = hsv[0];
        this.s = hsv[1];
        this.v = hsv[2];
        this.a = CUI.cuiConfig.a;
    }

    public void onClose() {
        CUI.cuiConfig.saveConfig();
        this.minecraft.setScreen(this.parent);
    }

    protected void init() {
        int x = 40;
        int y = 40;
        int width = 200;
        int height = 20;
        int spacing = 25;
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(x, y, width, height, (Component)Component.literal((String)"Hue"), this.h){

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)("Hue: " + (int)(this.value * 360.0))));
            }

            protected void applyValue() {
                ColorScreen.this.h = (float)this.value;
                ColorScreen.this.updateRGB();
            }
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(x, y + spacing, width, height, (Component)Component.literal((String)"Saturation"), this.s){

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)String.format("Saturation: %.2f", this.value)));
            }

            protected void applyValue() {
                ColorScreen.this.s = (float)this.value;
                ColorScreen.this.updateRGB();
            }
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(x, y + spacing * 2, width, height, (Component)Component.literal((String)"Value"), this.v){

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)String.format("Value: %.2f", this.value)));
            }

            protected void applyValue() {
                ColorScreen.this.v = (float)this.value;
                ColorScreen.this.updateRGB();
            }
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(x, y + spacing * 3, width, height, (Component)Component.literal((String)"Alpha"), this.a){

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)String.format("Alpha: %.2f", this.value)));
            }

            protected void applyValue() {
                ColorScreen.this.a = (float)this.value;
                ColorScreen.this.updateRGB();
            }
        });
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), btn -> this.onClose()).bounds(x, y + spacing * 4, width, height).build());
    }

    private void updateRGB() {
        int rgb = Color.HSBtoRGB(this.h, this.s, this.v);
        CUI.cuiConfig.r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        CUI.cuiConfig.g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        CUI.cuiConfig.b = (float)(rgb & 0xFF) / 255.0f;
        CUI.cuiConfig.a = this.a;
    }
}

