/*
 * Decompiled with CFR 0.152.
 */
package com.cui.mixin.client;

import com.cui.CUI;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public class HUDMixin {
    @Unique
    private static final ResourceLocation cui$detail = ResourceLocation.withDefaultNamespace((String)"hud/heart/detail");
    @Unique
    private static final ResourceLocation cui$detailBlinking = ResourceLocation.withDefaultNamespace((String)"hud/heart/detail_blinking");
    @Unique
    private static final ResourceLocation cui$detailHardcoreFull = ResourceLocation.withDefaultNamespace((String)"hud/heart/detail_hardcore_full");
    @Unique
    private static final ResourceLocation cui$detailHardcoreFullBlinking = ResourceLocation.withDefaultNamespace((String)"hud/heart/detail_hardcore_full_blinking");
    @Unique
    private static final ResourceLocation cui$detailHardcoreHalf = ResourceLocation.withDefaultNamespace((String)"hud/heart/detail_hardcore_half");
    @Unique
    private static final ResourceLocation cui$detailHardcoreHalfBlinking = ResourceLocation.withDefaultNamespace((String)"hud/heart/detail_hardcore_half_blinking");
    @Shadow
    @Final
    private Minecraft minecraft;

    @Unique
    private static ResourceLocation cui$getDetail(boolean hardcore, boolean halfHeart, boolean blinking) {
        if (!hardcore) {
            return blinking ? cui$detailBlinking : cui$detail;
        }
        if (!halfHeart) {
            return blinking ? cui$detailHardcoreFullBlinking : cui$detailHardcoreFull;
        }
        return blinking ? cui$detailHardcoreHalfBlinking : cui$detailHardcoreHalf;
    }

    @Inject(at={@At(value="HEAD")}, method={"renderItemHotbar(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"})
    private void renderHead(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        guiGraphics.flush();
        RenderSystem.setShaderColor((float)CUI.cuiConfig.r, (float)CUI.cuiConfig.g, (float)CUI.cuiConfig.b, (float)1.0f);
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V", shift=At.Shift.AFTER)}, method={"renderItemHotbar(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"})
    private void renderTail(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        guiGraphics.flush();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderHeart(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Gui$HeartType;IIZZZ)V"})
    private void renderHead(GuiGraphics guiGraphics, Gui.HeartType heartType, int x, int y, boolean hardcore, boolean halfHeart, boolean blinking, CallbackInfo ci) {
        if (heartType == Gui.HeartType.NORMAL) {
            guiGraphics.flush();
            RenderSystem.setShaderColor((float)CUI.cuiConfig.r, (float)CUI.cuiConfig.g, (float)CUI.cuiConfig.b, (float)1.0f);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"renderHeart(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Gui$HeartType;IIZZZ)V"})
    private void renderTail(GuiGraphics guiGraphics, Gui.HeartType heartType, int x, int y, boolean hardcore, boolean halfHeart, boolean blinking, CallbackInfo ci) {
        if (heartType == Gui.HeartType.NORMAL) {
            guiGraphics.flush();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blitSprite(RenderType::guiTextured, HUDMixin.cui$getDetail(hardcore, blinking, halfHeart), x, y, 9, 9);
        }
    }

    @Shadow
    public Font getFont() {
        return this.minecraft.font;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V", shift=At.Shift.BEFORE)}, method={"renderExperienceLevel(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"})
    private void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        int i1 = this.minecraft.player.experienceLevel;
        String string1 = "" + i1;
        int j1 = (guiGraphics.guiWidth() - this.getFont().width(string1)) / 2;
        int k1 = guiGraphics.guiHeight() - 31 - 4;
        guiGraphics.drawString(this.getFont(), string1, j1, k1, (int)(CUI.cuiConfig.r * 255.0f) << 16 | (int)(CUI.cuiConfig.g * 255.0f) << 8 | (int)(CUI.cuiConfig.b * 255.0f), false);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderExperienceBar(Lnet/minecraft/client/gui/GuiGraphics;I)V"})
    private void renderHead(GuiGraphics guiGraphics, int x, CallbackInfo ci) {
        guiGraphics.flush();
        RenderSystem.setShaderColor((float)CUI.cuiConfig.r, (float)CUI.cuiConfig.g, (float)CUI.cuiConfig.b, (float)1.0f);
    }

    @Inject(at={@At(value="TAIL")}, method={"renderExperienceBar(Lnet/minecraft/client/gui/GuiGraphics;I)V"})
    private void renderTail(GuiGraphics guiGraphics, int x, CallbackInfo ci) {
        guiGraphics.flush();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

