/*
 * Decompiled with CFR 0.152.
 */
package com.cui.core;

import com.cui.abs.core.data.Rectangle;
import com.cui.abs.core.data.ResourceBridge;
import com.cui.abs.core.rendering.gui.GuiRenderer;
import com.cui.core.CUI;
import java.awt.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ColorScreen
extends Screen {
    private final Screen parent;
    private static final Component TITLE = Component.literal((String)"CUI config");
    private float h;
    private float s;
    private float v;
    private float a;
    private float desaturation;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 61, 33);

    public ColorScreen(Screen parent) {
        super(TITLE);
        this.parent = parent;
        float[] hsv = Color.RGBtoHSB((int)(CUI.cuiConfig.r * 255.0f), (int)(CUI.cuiConfig.g * 255.0f), (int)(CUI.cuiConfig.b * 255.0f), null);
        this.h = hsv[0];
        this.s = hsv[1];
        this.v = hsv[2];
        this.a = CUI.cuiConfig.a;
        this.desaturation = CUI.cuiConfig.desaturation;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        GuiRenderer.blitSprite(guiGraphics, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "test"), new Rectangle(20, 100, 32, 32), CUI.cuiConfig.getRGB());
    }

    public void onClose() {
        CUI.cuiConfig.saveConfig();
        this.minecraft.setScreen(this.parent);
    }

    protected void init() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical().spacing(8));
        GridLayout gridLayout = new GridLayout();
        gridLayout.defaultCellSetting().paddingHorizontal(4).paddingBottom(4).alignHorizontallyCenter();
        GridLayout.RowHelper rowHelper = gridLayout.createRowHelper(1);
        int width = 150;
        int height = 20;
        rowHelper.addChild((LayoutElement)new AbstractSliderButton(0, 0, width, height, (Component)Component.literal((String)"Hue"), this.h){

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)("Hue: " + (int)(this.value * 360.0))));
            }

            protected void applyValue() {
                ColorScreen.this.h = (float)this.value;
                ColorScreen.this.updateRGB();
            }
        });
        rowHelper.addChild((LayoutElement)new AbstractSliderButton(0, 0, width, height, (Component)Component.literal((String)"Saturation"), this.s){

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)String.format("Saturation: %.2f", this.value)));
            }

            protected void applyValue() {
                ColorScreen.this.s = (float)this.value;
                ColorScreen.this.updateRGB();
            }
        });
        rowHelper.addChild((LayoutElement)new AbstractSliderButton(0, 0, width, height, (Component)Component.literal((String)"Value"), this.v){

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)String.format("Value: %.2f", this.value)));
            }

            protected void applyValue() {
                ColorScreen.this.v = (float)this.value;
                ColorScreen.this.updateRGB();
            }
        });
        rowHelper.addChild((LayoutElement)new AbstractSliderButton(0, 0, width, height, (Component)Component.literal((String)"Alpha"), this.a){

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)String.format("Alpha: %.2f", this.value)));
            }

            protected void applyValue() {
                ColorScreen.this.a = (float)this.value;
                ColorScreen.this.updateRGB();
            }
        });
        rowHelper.addChild((LayoutElement)new AbstractSliderButton(0, 0, width, height, (Component)Component.literal((String)"Text desaturation"), this.desaturation - 1.0f){

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)String.format("Text desaturation: %.2f", this.value + 1.0)));
            }

            protected void applyValue() {
                ColorScreen.this.desaturation = (float)(this.value + 1.0);
                ColorScreen.this.updateRGB();
            }
        });
        rowHelper.addChild((LayoutElement)Checkbox.builder((Component)Component.literal((String)"Enable CUI button"), (Font)this.font).maxWidth(width).selected(CUI.cuiConfig.enableButton).onValueChange((cb, state) -> {
            CUI.cuiConfig.enableButton = state;
            CUI.cuiConfig.saveConfig();
        }).build());
        this.layout.addToContents((LayoutElement)gridLayout);
        this.layout.addToFooter((LayoutElement)Button.builder((Component)Component.literal((String)"Done"), b -> this.onClose()).width(200).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
    }

    private void updateRGB() {
        int rgb = Color.HSBtoRGB(this.h, this.s, this.v);
        CUI.cuiConfig.r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        CUI.cuiConfig.g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        CUI.cuiConfig.b = (float)(rgb & 0xFF) / 255.0f;
        CUI.cuiConfig.a = this.a;
        CUI.cuiConfig.desaturation = this.desaturation;
        CUI.cuiConfig.color = new Color(CUI.cuiConfig.r, CUI.cuiConfig.g, CUI.cuiConfig.b, CUI.cuiConfig.a);
    }
}

