/*
 * Decompiled with CFR 0.152.
 */
package com.cui.mixin.client.misc.main;

import com.cui.abs.core.data.Rectangle;
import com.cui.abs.core.data.ResourceBridge;
import com.cui.abs.core.rendering.gui.GuiRenderer;
import com.cui.core.CUI;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Mixin(value={Gui.class})
public class HUDMixin {
    @Unique
    private static final ResourceLocation cui$detail = ResourceBridge.spriteNamespace("cui", "hud/heart/detail");
    @Unique
    private static final ResourceLocation cui$detailBlinking = ResourceBridge.spriteNamespace("cui", "hud/heart/detail_blinking");
    @Unique
    private static final ResourceLocation cui$detailHardcoreFull = ResourceBridge.spriteNamespace("cui", "hud/heart/detail_hardcore_full");
    @Unique
    private static final ResourceLocation cui$detailHardcoreFullBlinking = ResourceBridge.spriteNamespace("cui", "hud/heart/detail_hardcore_full_blinking");
    @Unique
    private static final ResourceLocation cui$detailHardcoreHalf = ResourceBridge.spriteNamespace("cui", "hud/heart/detail_hardcore_half");
    @Unique
    private static final ResourceLocation cui$detailHardcoreHalfBlinking = ResourceBridge.spriteNamespace("cui", "hud/heart/detail_hardcore_half_blinking");
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    public Font getFont() {
        return this.minecraft.font;
    }

    @Unique
    private static ResourceLocation cui$getDetail(boolean hardcore, boolean halfHeart, boolean blinking) {
        if (!hardcore) {
            return blinking ? cui$detailBlinking : cui$detail;
        }
        if (!halfHeart) {
            return blinking ? cui$detailHardcoreFullBlinking : cui$detailHardcoreFull;
        }
        return blinking ? cui$detailHardcoreHalfBlinking : cui$detailHardcoreHalf;
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIIIIIII)V"), method={"renderItemHotbar(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"})
    private void renderHotbar1(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int textureWidth, int textureHeight, int u, int v, int x, int y, int width, int height) {
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", sprite, new Rectangle(x, y, width, height), new Rectangle(u, v, textureWidth, textureHeight), (Integer)CUI.cuiConfig.getRGB());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V"), method={"renderItemHotbar(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"})
    private void renderHotbar2(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, int width, int height) {
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", sprite, new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIIIIIII)V"), method={"renderCrosshair(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"})
    private void injected2(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int textureWidth, int textureHeight, int u, int v, int x, int y, int width, int height) {
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", sprite, new Rectangle(x, y, width, height), new Rectangle(u, v, textureWidth, textureHeight), (Integer)CUI.cuiConfig.getRGB());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V"), method={"renderCrosshair(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"})
    private void injected3(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, int width, int height) {
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", sprite, new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
    }

    @Inject(at={@At(value="HEAD")}, method={"renderHeart(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Gui$HeartType;IIZZZ)V"}, cancellable=true)
    private void injected4(GuiGraphics guiGraphics, Gui.HeartType heartType, int x, int y, boolean hardcore, boolean blinking, boolean halfHeart, CallbackInfo ci) {
        if (heartType == Gui.HeartType.NORMAL || heartType == Gui.HeartType.CONTAINER) {
            GuiRenderer.blitSprite(guiGraphics, "GUI_TEXTURED", heartType.getSprite(hardcore, halfHeart, blinking), new Rectangle(x, y, 9, 9), CUI.cuiConfig.getRGB());
            if (heartType != Gui.HeartType.CONTAINER) {
                GuiRenderer.blitSprite(guiGraphics, "GUI_TEXTURED", HUDMixin.cui$getDetail(hardcore, halfHeart, blinking), new Rectangle(x, y, 9, 9));
            }
        } else {
            GuiRenderer.blitSprite(guiGraphics, "GUI_TEXTURED", heartType.getSprite(hardcore, halfHeart, blinking), new Rectangle(x, y, 9, 9), CUI.cuiConfig.getRGB());
        }
        ci.cancel();
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V"), method={"renderHeart(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Gui$HeartType;IIZZZ)V"})
    private void injected5(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, int width, int height) {
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", sprite, new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=2), method={"renderAirBubbles(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;III)V"})
    private void injected8(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, int width, int height) {
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "hud/air_empty_container"), new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", sprite, new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=0), method={"renderArmor(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;IIII)V"})
    private static void renderArmor1(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, int width, int height) {
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "hud/armor_container_half"), new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "hud/armor_full"), new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=1), method={"renderArmor(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;IIII)V"})
    private static void renderArmor2(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, int width, int height) {
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "hud/armor_container_half"), new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "hud/armor_half"), new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=2), method={"renderArmor(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;IIII)V"})
    private static void renderArmor3(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, int width, int height) {
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "armor_container"), new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=0), method={"renderFood(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;II)V"})
    private void renderFood1(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, int width, int height) {
        String hunger = sprite.toString().contains("hunger") ? "_hunger" : "";
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "hud/food_empty" + hunger), new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=1), method={"renderFood(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;II)V"})
    private void renderFood2(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, int width, int height) {
        String hunger = sprite.toString().contains("hunger") ? "_hunger" : "";
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "hud/food_full" + hunger), new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "hud/food_full" + hunger + "_bone"), new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=2), method={"renderFood(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;II)V"})
    private void renderFood3(GuiGraphics instance, RenderPipeline pipeline, ResourceLocation sprite, int x, int y, int width, int height) {
        String hunger = sprite.toString().contains("hunger") ? "_hunger" : "";
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "hud/food_half" + hunger), new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
        GuiRenderer.blitSprite(instance, "GUI_TEXTURED", ResourceBridge.spriteNamespace("cui", "hud/food_half" + hunger + "_bone"), new Rectangle(x, y, width, height), CUI.cuiConfig.getRGB());
    }
}

