/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen;

import com.erosmari.vitamin.shaded.bstats.bukkit.Metrics;
import com.soystargaze.lumen.commands.LumenCommandManager;
import com.soystargaze.lumen.config.ConfigHandler;
import com.soystargaze.lumen.connections.CoreProtectHandler;
import com.soystargaze.lumen.database.DatabaseHandler;
import com.soystargaze.lumen.items.LumenItems;
import com.soystargaze.lumen.lights.ItemLightsHandler;
import com.soystargaze.lumen.lights.integrations.ItemFAWEHandler;
import com.soystargaze.lumen.listeners.CraftPermissionListener;
import com.soystargaze.lumen.listeners.MobListener;
import com.soystargaze.lumen.listeners.TorchListener;
import com.soystargaze.lumen.mobs.ItemMobsHandler;
import com.soystargaze.lumen.utils.AsyncExecutor;
import com.soystargaze.lumen.utils.ConsoleUtils;
import com.soystargaze.lumen.utils.LumenConstants;
import com.soystargaze.lumen.utils.text.TextHandler;
import com.soystargaze.lumen.utils.text.legacy.LegacyTranslationHandler;
import com.soystargaze.lumen.utils.updater.UpdateOnFullLoad;
import com.soystargaze.lumen.utils.updater.UpdateOnJoinListener;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Lumen
extends JavaPlugin
implements Listener {
    private static Lumen instance;
    private LumenCommandManager commandManager;
    private LumenItems lumenItems;
    private CoreProtectHandler coreProtectHandler;
    private static final int BSTATS_PLUGIN_ID = 24638;

    public void onEnable() {
        instance = this;
        try {
            this.initializePlugin();
        }
        catch (Exception e) {
            TextHandler.get().logTranslated("plugin.enable_error", e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        AsyncExecutor.shutdown();
        DatabaseHandler.close();
        TextHandler.get().logTranslated("plugin.disabled", new Object[0]);
        instance = null;
    }

    private void initializePlugin() {
        LumenConstants.init((Plugin)this);
        this.loadConfigurations();
        this.initializeMetrics();
        try {
            this.initializeDatabase();
            this.registerEvents();
            this.registerServerLoadListener();
        }
        catch (Exception e) {
            TextHandler.get().logTranslated("plugin.enable_error", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public static Lumen getInstance() {
        return instance;
    }

    public LumenItems getLumenItems() {
        return this.lumenItems;
    }

    public CoreProtectHandler getCoreProtectHandler() {
        return this.coreProtectHandler;
    }

    private void loadConfigurations() {
        ConfigHandler.setup(this);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        TextHandler.init(this);
        this.setupTranslations();
        ConsoleUtils.displayAsciiArt(this);
        AsyncExecutor.initialize();
        this.initializeCommandManager();
        this.initializeItems();
        ConsoleUtils.displaySuccessMessage(this);
    }

    private void setupTranslations() {
        File translationsFolder = new File(this.getDataFolder(), "Translations");
        if (!translationsFolder.exists() && !translationsFolder.mkdirs()) {
            TextHandler.get().logTranslated("translations.folder_error", new Object[0]);
            return;
        }
        String[] defaults = new String[]{"en_us.yml", "es_es.yml", "fr_fr.yml", "de_de.yml", "pt_br.yml", "zh_cn.yml", "it_it.yml", "es_andaluh.yml"};
        boolean replace = this.getConfig().getBoolean("translations.force-update", true);
        for (String file : defaults) {
            try {
                this.saveResource("Translations/" + file, replace);
            }
            catch (Exception e) {
                TextHandler.get().registerTemporaryTranslation("translations.save_error", "Language cannot be saved: {0}");
                TextHandler.get().logTranslated("translations.save_error", file);
            }
        }
        String lang = ConfigHandler.getLanguage();
        if (TextHandler.get().isLanguageAvailable(lang)) {
            TextHandler.get().loadTranslations(this, lang);
        } else {
            TextHandler.get().registerTemporaryTranslation("translations.language_not_found", "Language not found: {0}");
            TextHandler.get().logTranslated("translations.language_not_found", lang);
            TextHandler.get().loadTranslations(this, TextHandler.get().getActiveLanguage());
        }
    }

    private void initializeDatabase() {
        try {
            DatabaseHandler.initialize(this);
        }
        catch (Exception e) {
            TextHandler.get().logTranslated("database.init_error", e.getMessage());
            throw new IllegalStateException(LegacyTranslationHandler.get("database.init_fatal_error"));
        }
    }

    private void initializeCommandManager() {
        try {
            if (this.commandManager == null) {
                this.commandManager = new LumenCommandManager(this);
                this.commandManager.registerCommands();
            }
        }
        catch (Exception e) {
            TextHandler.get().logTranslated("command.register_error", e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void initializeItems() {
        try {
            if (this.lumenItems == null) {
                this.lumenItems = new LumenItems((Plugin)this);
                this.lumenItems.registerItems();
            }
        }
        catch (Exception e) {
            TextHandler.get().logTranslated("items.init_error", e.getMessage());
        }
    }

    private void initializeCoreProtectIntegration() {
        if (!this.isCoreProtectAvailable()) {
            TextHandler.get().logTranslated("plugin.separator", new Object[0]);
            TextHandler.get().logTranslated("coreprotect.unavailable", new Object[0]);
            return;
        }
        try {
            this.coreProtectHandler = new CoreProtectHandler();
            if (this.isFAWEAvailable()) {
                ItemFAWEHandler.setCoreProtectHandler(this.coreProtectHandler);
            } else {
                TextHandler.get().logTranslated("plugin.separator", new Object[0]);
                TextHandler.get().logTranslated("coreprotect.integration.no_fawe", new Object[0]);
            }
            if (this.coreProtectHandler.isEnabled()) {
                TextHandler.get().logTranslated("plugin.separator", new Object[0]);
                TextHandler.get().logTranslated("coreprotect.enabled", new Object[0]);
            } else {
                TextHandler.get().logTranslated("plugin.separator", new Object[0]);
                TextHandler.get().logTranslated("coreprotect.unavailable", new Object[0]);
                this.coreProtectHandler = null;
            }
        }
        catch (Exception e) {
            TextHandler.get().logTranslated("coreprotect.error_initializing", e.getMessage());
            this.coreProtectHandler = null;
        }
        TextHandler.get().logTranslated("plugin.separator", new Object[0]);
    }

    private boolean isCoreProtectAvailable() {
        if (Bukkit.getPluginManager().getPlugin("CoreProtect") == null) {
            return false;
        }
        try {
            Class.forName("net.coreprotect.CoreProtect");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isFAWEAvailable() {
        if (Bukkit.getPluginManager().getPlugin("FastAsyncWorldEdit") == null) {
            return false;
        }
        try {
            Class.forName("com.fastasyncworldedit.core.FaweAPI");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void registerEvents() {
        try {
            ItemLightsHandler lightsHandler = new ItemLightsHandler(this);
            ItemMobsHandler mobsHandler = new ItemMobsHandler((Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new UpdateOnFullLoad(), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new UpdateOnJoinListener(), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new TorchListener((Plugin)this, lightsHandler, this.lumenItems), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new MobListener(mobsHandler, this.lumenItems), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new CraftPermissionListener(), (Plugin)this);
        }
        catch (Exception e) {
            TextHandler.get().logTranslated("events.register_error", e.getMessage());
        }
    }

    private void registerServerLoadListener() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private void initializeMetrics() {
        try {
            new Metrics((Plugin)this, 24638);
        }
        catch (Exception e) {
            String BSTATS_ERROR = "bstats.error";
            TextHandler.get().registerTemporaryTranslation("bstats.error", "BStats error: {0}");
            TextHandler.get().logTranslated("bstats.error", e.getMessage());
        }
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        this.initializeCoreProtectIntegration();
    }
}

