/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.commands;

import com.soystargaze.lumen.database.LightRegistry;
import com.soystargaze.lumen.utils.RemoveLightUtils;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ClearCommand
implements CommandExecutor,
TabCompleter {
    private static final Map<UUID, Long> confirmationRequests = new HashMap<UUID, Long>();
    private static final long CONFIRMATION_TIMEOUT = 30000L;

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            TextHandler.get().logTranslated("command.only_players", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("lumen.clear")) {
            TextHandler.get().sendMessage(player, "command.no_permission", new Object[0]);
            return true;
        }
        UUID playerId = player.getUniqueId();
        if (args.length == 0) {
            confirmationRequests.put(playerId, System.currentTimeMillis());
            TextHandler.get().sendAndLog(player, "command.clear.request", new Object[0]);
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("confirm")) {
            if (!confirmationRequests.containsKey(playerId)) {
                TextHandler.get().sendAndLog(player, "command.clear.no_request", new Object[0]);
                return true;
            }
            long requestTime = confirmationRequests.get(playerId);
            if (System.currentTimeMillis() - requestTime > 30000L) {
                confirmationRequests.remove(playerId);
                TextHandler.get().sendAndLog(player, "command.clear.expired", new Object[0]);
                return true;
            }
            List<Location> blocks = LightRegistry.getAllBlocks();
            int removedCount = blocks.stream().mapToInt(location -> RemoveLightUtils.removeLightBlock(location) ? 1 : 0).sum();
            LightRegistry.clearAllBlocks();
            confirmationRequests.remove(playerId);
            TextHandler.get().sendAndLog(player, "command.clear.success", removedCount);
            return true;
        }
        TextHandler.get().sendMessage(player, "command.clear.usage", new Object[0]);
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return List.of("confirm");
        }
        return new ArrayList<String>();
    }
}

