/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.commands;

import com.soystargaze.lumen.Lumen;
import com.soystargaze.lumen.database.LightRegistry;
import com.soystargaze.lumen.lights.LightHandler;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LightCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            TextHandler.get().logTranslated("command.only_players", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("lumen.light")) {
            TextHandler.get().sendMessage(player, "command.no_permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            TextHandler.get().sendMessage(player, "command.light.usage", new Object[0]);
            return true;
        }
        try {
            int lightLevel;
            int range = Integer.parseInt(args[0]);
            if (range < 1 || range > 150) {
                TextHandler.get().sendAndLog(player, "command.light.invalid_range", new Object[0]);
                return true;
            }
            int n = lightLevel = args.length > 1 ? Integer.parseInt(args[1]) : 15;
            if (lightLevel < 0 || lightLevel > 15) {
                TextHandler.get().sendAndLog(player, "command.light.invalid_level", new Object[0]);
                return true;
            }
            boolean includeSkylight = args.length > 2 && Boolean.parseBoolean(args[2]);
            int operationId = LightRegistry.registerOperation(UUID.randomUUID(), "Light Operation");
            LightHandler lightHandler = new LightHandler(Lumen.getInstance());
            lightHandler.placeLights(player, range, lightLevel, includeSkylight, operationId);
            TextHandler.get().sendAndLog(player, "command.light.success", lightLevel, operationId);
            return true;
        }
        catch (NumberFormatException e) {
            TextHandler.get().sendAndLog(player, "command.light.invalid_arguments", new Object[0]);
            return true;
        }
    }

    public List<String> onTabComplete(CommandSender sender, @NotNull Command command, @NotNull String alias, String @NotNull [] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!sender.hasPermission("lumen.light")) {
            return suggestions;
        }
        if (args.length == 1) {
            suggestions.add("<range>");
        } else if (args.length == 2) {
            suggestions.addAll(IntStream.rangeClosed(0, 15).mapToObj(String::valueOf).toList());
        } else if (args.length == 3) {
            suggestions.addAll(Arrays.asList("true", "false"));
        }
        return suggestions;
    }
}

