/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.commands;

import com.soystargaze.lumen.Lumen;
import com.soystargaze.lumen.config.ConfigHandler;
import com.soystargaze.lumen.connections.CoreProtectHandler;
import com.soystargaze.lumen.database.LightRegistry;
import com.soystargaze.lumen.lights.integrations.RedoFAWEHandler;
import com.soystargaze.lumen.utils.BatchProcessor;
import com.soystargaze.lumen.utils.DisplayUtil;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RedoCommand
implements CommandExecutor {
    private final Lumen plugin;
    private static final int MAX_RETRY_ATTEMPTS = 3;

    public RedoCommand(Lumen plugin) {
        this.plugin = plugin;
    }

    private CoreProtectHandler getCoreProtectHandler() {
        return this.plugin.getCoreProtectHandler();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            TextHandler.get().logTranslated("command.only_players", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("lumen.redo")) {
            TextHandler.get().sendMessage(player, "command.no_permission", new Object[0]);
            return true;
        }
        Integer operationId = LightRegistry.getLastSoftDeletedOperationId();
        if (operationId == null) {
            TextHandler.get().sendAndLog(player, "command.redo.no_previous_operations", new Object[0]);
            return true;
        }
        Map<Location, Integer> blocksWithLightLevels = LightRegistry.getSoftDeletedBlocksWithLightLevelByOperationId(operationId);
        if (blocksWithLightLevels.isEmpty()) {
            TextHandler.get().sendAndLog(player, "command.redo.no_blocks_found", operationId);
            return true;
        }
        if (this.isFAWEAvailable()) {
            RedoFAWEHandler.handleRedoWithFAWE(this.plugin, player, blocksWithLightLevels, operationId);
        } else {
            LinkedList<Map.Entry<Location, Integer>> blockQueue = new LinkedList<Map.Entry<Location, Integer>>(blocksWithLightLevels.entrySet());
            HashMap failedBlocks = new HashMap();
            ArrayList processedBlocks = new ArrayList();
            int maxBlocksPerTick = ConfigHandler.getInt("settings.command_lights_per_tick", 1000);
            int totalBlocks = blockQueue.size();
            DisplayUtil.showBossBar(player, 0.0);
            Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task -> {
                int processedCount = 0;
                while (!blockQueue.isEmpty() && processedCount < maxBlocksPerTick) {
                    int retryCount;
                    Map.Entry entry2 = (Map.Entry)blockQueue.poll();
                    if (entry2 == null) continue;
                    boolean success = this.processBlock((Location)entry2.getKey(), (Integer)entry2.getValue(), operationId, processedBlocks);
                    if (!success && (retryCount = failedBlocks.getOrDefault(entry2.getKey(), 0).intValue()) < 3) {
                        failedBlocks.put((Location)entry2.getKey(), retryCount + 1);
                    }
                    ++processedCount;
                }
                int remainingBlocks = blockQueue.size() + failedBlocks.size();
                double progress = 1.0 - (double)remainingBlocks / (double)totalBlocks;
                DisplayUtil.showBossBar(player, progress);
                DisplayUtil.showActionBar(player, progress);
                if (blockQueue.isEmpty() && failedBlocks.isEmpty()) {
                    CoreProtectHandler coreProtectHandler = this.getCoreProtectHandler();
                    if (!processedBlocks.isEmpty() && coreProtectHandler != null && coreProtectHandler.isEnabled()) {
                        coreProtectHandler.logLightPlacement(player.getName(), processedBlocks, Material.LIGHT);
                    }
                    LightRegistry.restoreSoftDeletedBlocksByOperationId(operationId);
                    TextHandler.get().sendAndLog(player, "command.redo.restoration_completed", operationId);
                    DisplayUtil.hideBossBar(player);
                    task.cancel();
                } else if (blockQueue.isEmpty()) {
                    TextHandler.get().logTranslated("command.redo.retrying_failed_blocks", new Object[0]);
                    failedBlocks.entrySet().removeIf(entry -> (Integer)entry.getValue() >= 3);
                    blockQueue.addAll(failedBlocks.entrySet());
                    failedBlocks.clear();
                }
            }, 0L, 1L);
        }
        TextHandler.get().sendAndLog(player, "command.redo.restoration_started", blocksWithLightLevels.size());
        return true;
    }

    private boolean isFAWEAvailable() {
        try {
            Class.forName("com.fastasyncworldedit.core.FaweAPI");
            return Bukkit.getPluginManager().isPluginEnabled("FastAsyncWorldEdit");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean processBlock(Location blockLocation, int lightLevel, int operationId, List<Location> processedBlocks) {
        Block block = blockLocation.getBlock();
        block.setType(Material.LIGHT, false);
        if (block.getType() == Material.LIGHT) {
            try {
                Levelled lightData = (Levelled)block.getBlockData();
                lightData.setLevel(lightLevel);
                block.setBlockData((BlockData)lightData, false);
                processedBlocks.add(blockLocation);
                BatchProcessor.addBlockToBatch(blockLocation, lightLevel, operationId);
                return true;
            }
            catch (ClassCastException e) {
                TextHandler.get().logTranslated("command.redo.light_level_error", blockLocation, e.getMessage());
            }
        } else {
            TextHandler.get().logTranslated("command.redo.cannot_set_light", blockLocation);
        }
        return false;
    }
}

