/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.commands;

import com.soystargaze.lumen.Lumen;
import com.soystargaze.lumen.connections.CoreProtectHandler;
import com.soystargaze.lumen.database.LightRegistry;
import com.soystargaze.lumen.utils.RemoveLightUtils;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RemoveCommand
implements CommandExecutor,
TabCompleter {
    private final Lumen plugin;

    public RemoveCommand(Lumen plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            TextHandler.get().logTranslated("command.only_players", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("lumen.remove")) {
            TextHandler.get().sendMessage(player, "command.no_permission", new Object[0]);
            return true;
        }
        if (args.length != 2 || !args[0].equalsIgnoreCase("area")) {
            TextHandler.get().sendMessage(player, "command.remove.usage", new Object[0]);
            return true;
        }
        try {
            boolean coreProtectAvailable;
            int range = Integer.parseInt(args[1]);
            if (range < 1 || range > 100) {
                TextHandler.get().sendAndLog(player, "command.remove.invalid_range", new Object[0]);
                return true;
            }
            Location playerLocation = player.getLocation();
            List<Location> blocks = LightRegistry.getBlocksInRange(playerLocation, range);
            if (blocks.isEmpty()) {
                TextHandler.get().sendAndLog(player, "command.remove.area.no_blocks", range);
                return true;
            }
            CoreProtectHandler coreProtectHandler = this.plugin.getCoreProtectHandler();
            boolean bl = coreProtectAvailable = coreProtectHandler != null && coreProtectHandler.isEnabled();
            if (!coreProtectAvailable) {
                TextHandler.get().sendAndLog(player, "command.remove.coreprotect_not_available", new Object[0]);
            }
            int removedCount = this.removeAndLogBlocks(blocks, player, coreProtectAvailable ? coreProtectHandler : null);
            TextHandler.get().sendAndLog(player, "command.remove.area.success", removedCount, range);
            return true;
        }
        catch (NumberFormatException e) {
            TextHandler.get().sendAndLog(player, "command.remove.invalid_range", new Object[0]);
            return true;
        }
    }

    private int removeAndLogBlocks(List<Location> blocks, Player player, CoreProtectHandler coreProtectHandler) {
        int removedCount = 0;
        for (Location block : blocks) {
            if (!RemoveLightUtils.removeLightBlock(block)) continue;
            ++removedCount;
        }
        if (removedCount > 0 && coreProtectHandler != null) {
            coreProtectHandler.logRemoval(player.getName(), blocks, Material.LIGHT);
        }
        return removedCount;
    }

    public List<String> onTabComplete(CommandSender sender, @NotNull Command command, @NotNull String alias, String @NotNull [] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!sender.hasPermission("lumen.remove")) {
            return suggestions;
        }
        if (args.length == 1) {
            suggestions.add("area");
        } else if (args.length == 2 && args[0].equalsIgnoreCase("area")) {
            suggestions.add("<range>");
        }
        return suggestions;
    }
}

