/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.commands;

import com.soystargaze.lumen.Lumen;
import com.soystargaze.lumen.connections.CoreProtectHandler;
import com.soystargaze.lumen.database.LightRegistry;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class UndoCommand
implements CommandExecutor {
    private final Lumen plugin;

    public UndoCommand(Lumen plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        List<Integer> lastOperations;
        if (!(sender instanceof Player)) {
            TextHandler.get().logTranslated("command.only_players", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("lumen.undo")) {
            TextHandler.get().sendMessage(player, "command.no_permission", new Object[0]);
            return true;
        }
        int count = 1;
        if (args.length > 0) {
            try {
                count = Integer.parseInt(args[0]);
                if (count < 1) {
                    TextHandler.get().sendAndLog(player, "command.undo.invalid_count", new Object[0]);
                    return true;
                }
            }
            catch (NumberFormatException e) {
                TextHandler.get().sendAndLog(player, "command.undo.invalid_count", new Object[0]);
                return true;
            }
        }
        if ((lastOperations = LightRegistry.getLastOperations(count)).isEmpty()) {
            TextHandler.get().sendAndLog(player, "command.undo.no_previous_operations", new Object[0]);
            return true;
        }
        int totalRemovedBlocks = this.removeLightBlocksByOperations(lastOperations, player);
        if (totalRemovedBlocks > 0) {
            TextHandler.get().sendAndLog(player, "command.undo.success", totalRemovedBlocks, count);
        } else {
            TextHandler.get().sendAndLog(player, "command.undo.no_blocks", count);
        }
        return true;
    }

    private int removeLightBlocksByOperations(List<Integer> operationIds, Player player) {
        CoreProtectHandler coreProtectHandler = this.plugin.getCoreProtectHandler();
        ArrayList<Location> allRemovedBlocks = new ArrayList<Location>();
        for (int operationId : operationIds) {
            List<Location> blocks = LightRegistry.getBlocksByOperationId(operationId);
            if (blocks.isEmpty()) continue;
            ArrayList<Location> removedBlocks = new ArrayList<Location>();
            for (Location location : blocks) {
                if (!this.removeLightBlock(location)) continue;
                removedBlocks.add(location);
            }
            if (removedBlocks.isEmpty()) continue;
            LightRegistry.softDeleteBlocksByOperationId(operationId);
            allRemovedBlocks.addAll(removedBlocks);
        }
        if (!allRemovedBlocks.isEmpty() && coreProtectHandler != null && coreProtectHandler.isEnabled()) {
            coreProtectHandler.logRemoval(player.getName(), allRemovedBlocks, Material.LIGHT);
        }
        return allRemovedBlocks.size();
    }

    private boolean removeLightBlock(Location location) {
        if (location.getBlock().getType() == Material.LIGHT) {
            location.getBlock().setType(Material.AIR, false);
            return true;
        }
        return false;
    }
}

