/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.lights.integrations;

import com.fastasyncworldedit.bukkit.FaweBukkitWorld;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.soystargaze.lumen.connections.CoreProtectHandler;
import com.soystargaze.lumen.database.LightRegistry;
import com.soystargaze.lumen.lights.integrations.FAWEHandler;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class ItemFAWEHandler {
    private static CoreProtectHandler coreProtectHandler;

    public ItemFAWEHandler() {
        coreProtectHandler = null;
    }

    public static void setCoreProtectHandler(CoreProtectHandler handler) {
        coreProtectHandler = handler;
    }

    public static boolean isFAWEAvailable() {
        try {
            Class.forName("com.fastasyncworldedit.core.FaweAPI");
            Class.forName("com.sk89q.worldedit.WorldEdit");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void placeLightsWithFAWE(Player player, List<Location> locations, int lightLevel, int operationId) {
        if (!ItemFAWEHandler.isFAWEAvailable()) {
            TextHandler.get().sendAndLog(player, "light.error.fawe_not_found", new Object[0]);
            return;
        }
        if (locations == null || locations.isEmpty()) {
            TextHandler.get().sendAndLog(player, "light.error.no_locations", new Object[0]);
            return;
        }
        if (lightLevel < 0 || lightLevel > 15) {
            TextHandler.get().sendAndLog(player, "light.error.invalid_light_level", lightLevel);
            return;
        }
        org.bukkit.World bukkitWorld = locations.getFirst().getWorld();
        if (bukkitWorld == null) {
            TextHandler.get().sendAndLog(player, "light.error.null_world", new Object[0]);
            return;
        }
        FaweBukkitWorld faweWorld = FaweBukkitWorld.of((org.bukkit.World)bukkitWorld);
        try (EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world((World)faweWorld).build();){
            BlockType lightType = BlockTypes.LIGHT;
            if (lightType == null) {
                TextHandler.get().sendAndLog(player, "light.error.light_type_not_supported", new Object[0]);
                return;
            }
            BlockState lightState = lightType.getDefaultState();
            Property levelProperty = lightType.getProperty("level");
            BlockState customLightState = lightState.with(levelProperty, (Object)lightLevel);
            List<Location> placedLocations = FAWEHandler.processLocations(editSession, locations, customLightState);
            LightRegistry.addBlocksAsync(placedLocations, lightLevel, operationId);
            if (coreProtectHandler != null && coreProtectHandler.isEnabled()) {
                try {
                    coreProtectHandler.logLightPlacement(player.getName(), placedLocations, Material.LIGHT);
                }
                catch (Exception ex) {
                    TextHandler.get().logTranslated("coreprotect.placement.error", ex.getMessage());
                }
            } else {
                TextHandler.get().logTranslated("coreprotect.integration.not_found", new Object[0]);
            }
            try {
                editSession.flushQueue();
            }
            catch (Exception e) {
                TextHandler.get().logTranslated("light.error.flush_failed", e.getMessage());
            }
            TextHandler.get().sendAndLog(player, "light.success.fawe", placedLocations.size());
        }
        catch (Exception e) {
            TextHandler.get().sendAndLog(player, "light.error.fawe_failed", e.getMessage());
        }
    }
}

