/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.lights.integrations;

import com.soystargaze.lumen.Lumen;
import com.soystargaze.lumen.connections.CoreProtectHandler;
import com.soystargaze.lumen.database.LightRegistry;
import com.soystargaze.lumen.lights.integrations.FAWEHandler;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RedoFAWEHandler {
    public static void handleRedoWithFAWE(Lumen plugin, Player player, Map<Location, Integer> blocksWithLightLevels, int operationId) {
        if (blocksWithLightLevels == null || blocksWithLightLevels.isEmpty()) {
            TextHandler.get().sendAndLog(player, "command.redo.no_blocks_to_restore", operationId);
            return;
        }
        ArrayList<Location> locations = new ArrayList<Location>(blocksWithLightLevels.keySet());
        int lightLevel = blocksWithLightLevels.values().iterator().next();
        if (lightLevel < 0 || lightLevel > 15) {
            TextHandler.get().sendAndLog(player, "command.redo.invalid_light_level", lightLevel);
            return;
        }
        if (FAWEHandler.isFAWEAvailable()) {
            TextHandler.get().sendAndLog(player, "command.redo.fawe_not_available", new Object[0]);
            return;
        }
        CoreProtectHandler coreProtectHandler = plugin.getCoreProtectHandler();
        if (coreProtectHandler == null || !coreProtectHandler.isEnabled()) {
            TextHandler.get().sendAndLog(player, "command.redo.coreprotect_not_available", new Object[0]);
        }
        FAWEHandler.placeLightBlocks(locations, lightLevel, player, coreProtectHandler);
        plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> {
            LightRegistry.restoreSoftDeletedBlocksByOperationId(operationId);
            TextHandler.get().sendAndLog(player, "command.redo.restoration_completed", operationId);
        });
    }
}

