/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.listeners;

import com.soystargaze.lumen.items.LumenItems;
import com.soystargaze.lumen.mobs.ItemMobsHandler;
import com.soystargaze.lumen.utils.ItemEffectUtil;
import com.soystargaze.lumen.utils.LumenConstants;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class MobListener
implements Listener {
    private final ItemMobsHandler mobsHandler;
    private final LumenItems lumenItems;
    private final NamespacedKey lumenIdKey;

    public MobListener(ItemMobsHandler mobsHandler, LumenItems lumenItems) {
        this.mobsHandler = mobsHandler;
        this.lumenItems = lumenItems;
        this.lumenIdKey = LumenConstants.getLumenIdKey();
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        String id;
        PersistentDataContainer itemContainer;
        ItemStack itemInHand = event.getItemInHand();
        if (itemInHand.getItemMeta() != null && (itemContainer = itemInHand.getItemMeta().getPersistentDataContainer()).has(this.lumenIdKey, PersistentDataType.STRING) && "guard".equals(id = (String)itemContainer.get(this.lumenIdKey, PersistentDataType.STRING))) {
            Block placedBlock = event.getBlock();
            Player player = event.getPlayer();
            Location placedLocation = placedBlock.getLocation();
            BlockState blockState = placedBlock.getState();
            if (blockState instanceof TileState) {
                TileState tileState = (TileState)blockState;
                this.transferPersistentData(itemContainer, tileState.getPersistentDataContainer());
                tileState.update();
            }
            this.mobsHandler.registerAntiMobArea(player, placedLocation);
            ItemEffectUtil.playEffect(placedLocation, "guard");
            TextHandler.get().sendAndLog(player, "torch.guard_placed", placedLocation);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        String id;
        TileState tileState;
        PersistentDataContainer blockContainer;
        Block brokenBlock = event.getBlock();
        Player player = event.getPlayer();
        BlockState blockState = brokenBlock.getState();
        if (blockState instanceof TileState && (blockContainer = (tileState = (TileState)blockState).getPersistentDataContainer()).has(this.lumenIdKey, PersistentDataType.STRING) && "guard".equals(id = (String)blockContainer.get(this.lumenIdKey, PersistentDataType.STRING))) {
            Location brokenLocation = brokenBlock.getLocation();
            this.mobsHandler.unregisterAntiMobArea(brokenLocation);
            ItemStack customItem = this.lumenItems.getLumenItem(id);
            if (customItem != null) {
                brokenBlock.getWorld().dropItemNaturally(brokenBlock.getLocation(), customItem.clone());
                event.setDropItems(false);
                TextHandler.get().sendAndLog(player, "torch.guard_broken", brokenLocation);
            }
        }
    }

    private void transferPersistentData(PersistentDataContainer source, PersistentDataContainer target) {
        for (NamespacedKey key : source.getKeys()) {
            if (!source.has(key, PersistentDataType.STRING)) continue;
            target.set(key, PersistentDataType.STRING, (Object)Objects.requireNonNull((String)source.get(key, PersistentDataType.STRING)));
        }
    }
}

