/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.utils;

import com.soystargaze.lumen.config.ConfigHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class DisplayUtil {
    private static final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();

    public static void showBossBar(Player player, double progress) {
        if (!ConfigHandler.isBossBarEnabled()) {
            return;
        }
        String message = ConfigHandler.getBossBarMessage().replace("{progress}", String.valueOf((int)(progress * 100.0)));
        BarColor color = ConfigHandler.getBossBarColor();
        BarStyle style = ConfigHandler.getBossBarStyle();
        BossBar bossBar = bossBars.get(player.getUniqueId());
        if (bossBar == null) {
            bossBar = Bukkit.createBossBar((String)message, (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
            bossBars.put(player.getUniqueId(), bossBar);
            bossBar.addPlayer(player);
        }
        bossBar.setTitle(message);
        bossBar.setProgress(Math.clamp(progress, 0.0, 1.0));
    }

    public static void hideBossBar(Player player) {
        BossBar bossBar = bossBars.remove(player.getUniqueId());
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    public static void showActionBar(Player player, double progress) {
        if (!ConfigHandler.isActionBarEnabled()) {
            return;
        }
        String message = ConfigHandler.getActionBarMessage().replace("{progress}", String.valueOf((int)(progress * 100.0)));
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
    }

    public static void clearAllBossBars() {
        for (BossBar bossBar : bossBars.values()) {
            bossBar.removeAll();
        }
        bossBars.clear();
    }
}

