/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.utils.text;

import com.soystargaze.lumen.utils.text.legacy.LegacyLoggingUtils;
import com.soystargaze.lumen.utils.text.legacy.LegacyTranslationHandler;
import com.soystargaze.lumen.utils.text.modern.ModernLoggingUtils;
import com.soystargaze.lumen.utils.text.modern.ModernTranslationHandler;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TextHandler {
    private static TextHandler instance;
    private final boolean modern;

    private TextHandler(JavaPlugin plugin) {
        boolean modernDetected;
        try {
            Class.forName("com.destroystokyo.paper.event.player.PlayerJumpEvent");
            modernDetected = true;
        }
        catch (ClassNotFoundException e) {
            modernDetected = false;
        }
        this.modern = modernDetected;
        if (this.modern) {
            plugin.getLogger().info("[Lumen] Using ModernTranslationHandler (Paper/fork detected)");
        } else {
            plugin.getLogger().info("[Lumen] Using LegacyTranslationHandler");
        }
    }

    public static void init(JavaPlugin plugin) {
        if (instance == null) {
            instance = new TextHandler(plugin);
        }
    }

    public static TextHandler get() {
        if (instance == null) {
            throw new IllegalStateException("TextHandler has not been initialized.");
        }
        return instance;
    }

    public void loadTranslations(JavaPlugin plugin, String language) {
        if (this.modern) {
            ModernTranslationHandler.loadTranslations(plugin, language);
        } else {
            LegacyTranslationHandler.loadTranslations(plugin, language);
        }
    }

    public boolean isLanguageAvailable(String language) {
        if (this.modern) {
            return ModernTranslationHandler.isLanguageAvailable(language);
        }
        return LegacyTranslationHandler.isLanguageAvailable(language);
    }

    public void setActiveLanguage(String language) {
        if (this.modern) {
            ModernTranslationHandler.setActiveLanguage(language);
        } else {
            LegacyTranslationHandler.setActiveLanguage(language);
        }
    }

    public String getActiveLanguage() {
        if (this.modern) {
            return ModernTranslationHandler.getActiveLanguage();
        }
        return LegacyTranslationHandler.getActiveLanguage();
    }

    public void registerTemporaryTranslation(String key, String message) {
        if (this.modern) {
            ModernTranslationHandler.registerTemporaryTranslation(key, message);
        } else {
            LegacyTranslationHandler.registerTemporaryTranslation(key, message);
        }
    }

    public int getLoadedTranslationsCount() {
        if (this.modern) {
            return ModernTranslationHandler.getLoadedTranslationsCount();
        }
        return LegacyTranslationHandler.getLoadedTranslationsCount();
    }

    public void sendMessage(Player player, String key, Object ... args) {
        if (this.modern) {
            ModernLoggingUtils.sendMessage(player, key, args);
        } else {
            LegacyLoggingUtils.sendMessage(player, key, args);
        }
    }

    public void logTranslated(String key, Object ... args) {
        if (this.modern) {
            ModernLoggingUtils.logTranslated(key, args);
        } else {
            LegacyLoggingUtils.logTranslated(key, args);
        }
    }

    public void sendAndLog(Player player, String key, Object ... args) {
        if (this.modern) {
            ModernLoggingUtils.sendAndLog(player, key, args);
        } else {
            LegacyLoggingUtils.sendAndLog(player, key, args);
        }
    }

    public Object getMessage(String key, Object ... args) {
        if (this.modern) {
            return ModernLoggingUtils.getMessage(key, args);
        }
        return LegacyLoggingUtils.getMessage(key, args);
    }
}

