/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.utils.updater;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.soystargaze.lumen.Lumen;
import com.soystargaze.lumen.utils.AsyncExecutor;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import org.bukkit.entity.Player;

public class UpdateChecker {
    private static final String API_URL = "https://api.modrinth.com/v2/project/%s/version";
    private static final String PROJECT_ID = "lumen";
    private static final String CURRENT_VERSION = Lumen.getInstance().getDescription().getVersion();
    private static final String DOWNLOAD_URL = "https://modrinth.com/plugin/lumen";

    public static void checkForUpdates(Player player) {
        AsyncExecutor.getExecutor().execute(() -> {
            try {
                String url = String.format(API_URL, PROJECT_ID);
                URI uri = new URI(url);
                URL urlObj = uri.toURL();
                HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "soystargaze/Lumen/" + CURRENT_VERSION + " (dev@soystargaze.com)");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    Gson gson = new Gson();
                    JsonArray versions = (JsonArray)gson.fromJson(response.toString(), JsonArray.class);
                    if (!versions.isEmpty()) {
                        JsonObject latestVersion = versions.get(0).getAsJsonObject();
                        String latestVersionNumber = latestVersion.get("version_number").getAsString();
                        if (!CURRENT_VERSION.equals(latestVersionNumber)) {
                            if (player != null && player.isOnline()) {
                                TextHandler.get().sendAndLog(player, "plugin.update_available", latestVersionNumber, DOWNLOAD_URL);
                            } else {
                                TextHandler.get().logTranslated("plugin.update_available", latestVersionNumber, DOWNLOAD_URL);
                            }
                        } else if (player != null && player.isOnline()) {
                            TextHandler.get().sendAndLog(player, "plugin.no_update_available", new Object[0]);
                        } else {
                            TextHandler.get().logTranslated("plugin.no_update_available", new Object[0]);
                        }
                    }
                } else if (player != null && player.isOnline()) {
                    TextHandler.get().sendAndLog(player, "plugin.update_check_failed", String.valueOf(responseCode));
                } else {
                    TextHandler.get().logTranslated("plugin.update_check_failed", String.valueOf(responseCode));
                }
            }
            catch (Exception e) {
                if (player != null && player.isOnline()) {
                    TextHandler.get().sendAndLog(player, "plugin.update_check_error", e.getMessage());
                }
                TextHandler.get().logTranslated("plugin.update_check_error", e.getMessage());
            }
        });
    }
}

