/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.commands;

import com.soystargaze.lumen.Lumen;
import com.soystargaze.lumen.items.LumenItems;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GiveCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        int amount;
        if (!(sender instanceof Player)) {
            TextHandler.get().logTranslated("command.only_players", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("lumen.give")) {
            TextHandler.get().sendMessage(player, "command.no_permission", new Object[0]);
            return true;
        }
        if (args.length < 2 || args.length > 3) {
            TextHandler.get().sendMessage(player, "command.give.usage", new Object[0]);
            return true;
        }
        String target = args[0];
        String torchType = args[1];
        int n = amount = args.length == 3 ? this.parseAmount(args[2], sender) : 1;
        if (amount <= 0) {
            return true;
        }
        LumenItems lumenItems = Lumen.getInstance().getLumenItems();
        ItemStack torch = lumenItems.getLumenItem(torchType.toLowerCase());
        if (torch == null) {
            TextHandler.get().sendMessage(player, "command.give.invalid_torch", new Object[0]);
            TextHandler.get().logTranslated("command.give.invalid_torch", new Object[0]);
            return true;
        }
        torch.setAmount(amount);
        if (target.equalsIgnoreCase("all") || target.equalsIgnoreCase("@a")) {
            Bukkit.getOnlinePlayers().forEach(p -> {
                player.getInventory().addItem(new ItemStack[]{torch.clone()});
                TextHandler.get().sendAndLog(player, "command.give.received", amount, torchType);
            });
            TextHandler.get().sendMessage(player, "command.give.success_all", amount, torchType);
            TextHandler.get().logTranslated("command.give.success_all", amount, torchType);
        } else {
            Player p2 = Bukkit.getPlayerExact((String)target);
            if (p2 != null && player.isOnline()) {
                player.getInventory().addItem(new ItemStack[]{torch.clone()});
                TextHandler.get().sendAndLog(player, "command.give.received", amount, torchType);
                TextHandler.get().sendMessage(player, "command.give.success_one", target, amount, torchType);
                TextHandler.get().logTranslated("command.give.success_one", target, amount, torchType);
            } else {
                TextHandler.get().sendMessage(player, "command.give.invalid_player", new Object[0]);
                TextHandler.get().logTranslated("command.give.invalid_player", new Object[0]);
            }
        }
        return true;
    }

    private int parseAmount(String arg, CommandSender sender) {
        if (!(sender instanceof Player)) {
            TextHandler.get().logTranslated("command.only_players", new Object[0]);
            return -1;
        }
        Player player = (Player)sender;
        try {
            int amount = Integer.parseInt(arg);
            if (amount <= 0) {
                TextHandler.get().sendMessage(player, "command.give.invalid_amount", new Object[0]);
                TextHandler.get().logTranslated("command.give.invalid_amount", new Object[0]);
                return -1;
            }
            return amount;
        }
        catch (NumberFormatException e) {
            TextHandler.get().sendMessage(player, "command.give.invalid_amount", new Object[0]);
            TextHandler.get().logTranslated("command.give.invalid_amount", new Object[0]);
            return -1;
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            Bukkit.getOnlinePlayers().forEach(player -> suggestions.add(player.getName()));
            suggestions.add("all");
        } else if (args.length == 2) {
            suggestions.add("torch");
            suggestions.add("guard");
        }
        return suggestions;
    }
}

