/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.commands;

import com.soystargaze.lumen.Lumen;
import com.soystargaze.lumen.commands.CancelCommand;
import com.soystargaze.lumen.commands.ClearCommand;
import com.soystargaze.lumen.commands.GiveCommand;
import com.soystargaze.lumen.commands.LightCommand;
import com.soystargaze.lumen.commands.RedoCommand;
import com.soystargaze.lumen.commands.ReloadCommand;
import com.soystargaze.lumen.commands.RemoveCommand;
import com.soystargaze.lumen.commands.UndoCommand;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LumenCommandExecutor
implements CommandExecutor,
TabCompleter {
    private final RemoveCommand removeCommand;
    private final UndoCommand undoCommand;
    private final ClearCommand clearCommand;
    private final RedoCommand redoCommand;
    private final LightCommand lightCommand;
    private final CancelCommand cancelCommand;
    private final GiveCommand giveCommand;
    private final ReloadCommand reloadCommand;

    public LumenCommandExecutor(Lumen plugin, RemoveCommand removeCommand, UndoCommand undoCommand, ClearCommand clearCommand, RedoCommand redoCommand) {
        this.removeCommand = removeCommand;
        this.undoCommand = undoCommand;
        this.clearCommand = clearCommand;
        this.redoCommand = redoCommand;
        this.lightCommand = new LightCommand();
        this.cancelCommand = new CancelCommand();
        this.giveCommand = new GiveCommand();
        this.reloadCommand = new ReloadCommand(plugin);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            TextHandler.get().logTranslated("command.only_players", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("lumen.use")) {
            TextHandler.get().sendMessage(player, "command.no_permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            TextHandler.get().sendMessage(player, "command.usage", new Object[0]);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        String[] subArgs = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
        return switch (subCommand) {
            case "light" -> this.lightCommand.onCommand(sender, command, label, subArgs);
            case "cancel" -> this.cancelCommand.onCommand(sender, command, label, subArgs);
            case "undo" -> this.undoCommand.onCommand(sender, command, label, subArgs);
            case "redo" -> this.redoCommand.onCommand(sender, command, label, subArgs);
            case "clear" -> this.clearCommand.onCommand(sender, command, label, subArgs);
            case "remove" -> this.removeCommand.onCommand(sender, command, label, subArgs);
            case "give" -> this.giveCommand.onCommand(sender, command, label, subArgs);
            case "reload" -> this.reloadCommand.onCommand(sender, command, label, subArgs);
            default -> {
                TextHandler.get().sendMessage(player, "command.usage", new Object[0]);
                yield true;
            }
        };
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>();
            if (sender.hasPermission("lumen.lang")) {
                subCommands.add("lang");
            }
            if (sender.hasPermission("lumen.light")) {
                subCommands.add("light");
            }
            if (sender.hasPermission("lumen.cancel")) {
                subCommands.add("cancel");
            }
            if (sender.hasPermission("lumen.undo")) {
                subCommands.add("undo");
            }
            if (sender.hasPermission("lumen.redo")) {
                subCommands.add("redo");
            }
            if (sender.hasPermission("lumen.clear")) {
                subCommands.add("clear");
            }
            if (sender.hasPermission("lumen.remove")) {
                subCommands.add("remove");
            }
            if (sender.hasPermission("lumen.give")) {
                subCommands.add("give");
            }
            if (sender.hasPermission("lumen.reload")) {
                subCommands.add("reload");
            }
            return subCommands;
        }
        String subCommand = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        return switch (subCommand) {
            case "light" -> this.lightCommand.onTabComplete(sender, command, alias, subArgs);
            case "clear" -> this.clearCommand.onTabComplete(sender, command, alias, subArgs);
            case "remove" -> this.removeCommand.onTabComplete(sender, command, alias, subArgs);
            case "give" -> this.giveCommand.onTabComplete(sender, command, alias, subArgs);
            default -> new ArrayList<String>();
        };
    }
}

