/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.commands;

import com.soystargaze.lumen.Lumen;
import com.soystargaze.lumen.commands.ClearCommand;
import com.soystargaze.lumen.commands.LumenCommandExecutor;
import com.soystargaze.lumen.commands.RedoCommand;
import com.soystargaze.lumen.commands.RemoveCommand;
import com.soystargaze.lumen.commands.UndoCommand;
import java.util.Objects;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;

public class LumenCommandManager {
    private final Lumen plugin;
    private final RemoveCommand removeCommand;
    private final UndoCommand undoCommand;
    private final ClearCommand clearCommand;
    private final RedoCommand redoCommand;

    public LumenCommandManager(Lumen plugin) {
        this.plugin = plugin;
        this.removeCommand = new RemoveCommand(plugin);
        this.undoCommand = new UndoCommand(plugin);
        this.clearCommand = new ClearCommand();
        this.redoCommand = new RedoCommand(plugin);
    }

    public void registerCommands() {
        this.registerCommand("lumen");
        this.registerCommand("lu");
        this.registerCommand("l");
    }

    private void registerCommand(String commandName) {
        LumenCommandExecutor executor = new LumenCommandExecutor(this.plugin, this.removeCommand, this.undoCommand, this.clearCommand, this.redoCommand);
        Objects.requireNonNull(this.plugin.getCommand(commandName)).setExecutor((CommandExecutor)executor);
        Objects.requireNonNull(this.plugin.getCommand(commandName)).setTabCompleter((TabCompleter)executor);
    }
}

