/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.commands;

import com.soystargaze.lumen.config.ConfigHandler;
import com.soystargaze.lumen.lights.ItemLightsHandler;
import com.soystargaze.lumen.utils.text.TextHandler;
import com.soystargaze.lumen.utils.text.legacy.LegacyTranslationHandler;
import com.soystargaze.lumen.utils.text.modern.ModernTranslationHandler;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ReloadCommand
implements CommandExecutor {
    private final JavaPlugin plugin;

    public ReloadCommand(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            TextHandler.get().logTranslated("command.only_players", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("lumen.reload")) {
            TextHandler.get().sendMessage(player, "command.no_permission", new Object[0]);
            return true;
        }
        try {
            this.reloadConfig();
            int loadedTranslations = this.reloadTranslations();
            TextHandler.get().sendMessage(player, "command.reload.success", loadedTranslations);
        }
        catch (Exception e) {
            TextHandler.get().sendMessage(player, "command.reload.error", new Object[0]);
            TextHandler.get().logTranslated("command.reload.error", e.getMessage());
        }
        return true;
    }

    private void reloadConfig() {
        this.plugin.reloadConfig();
        ConfigHandler.reload();
        ItemLightsHandler.reloadSettings();
    }

    private int reloadTranslations() {
        String language = this.plugin.getConfig().getString("language", "en_us");
        if (Bukkit.getServer().getName().equalsIgnoreCase("Paper")) {
            ModernTranslationHandler.clearTranslations();
            ModernTranslationHandler.loadTranslations(this.plugin, language);
            return ModernTranslationHandler.getLoadedTranslationsCount();
        }
        LegacyTranslationHandler.clearTranslations();
        LegacyTranslationHandler.loadTranslations(this.plugin, language);
        return LegacyTranslationHandler.getLoadedTranslationsCount();
    }
}

