/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.connections;

import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.List;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;

public class CoreProtectHandler {
    private CoreProtectAPI coreProtectAPI;

    public CoreProtectHandler() {
        if (this.isCoreProtectAvailable()) {
            this.setupCoreProtect();
        } else {
            this.coreProtectAPI = null;
            TextHandler.get().logTranslated("plugin.separator", new Object[0]);
            TextHandler.get().logTranslated("coreprotect.integration.not_found_or_disabled", new Object[0]);
        }
    }

    private boolean isCoreProtectAvailable() {
        try {
            Class.forName("net.coreprotect.CoreProtect");
            return Bukkit.getPluginManager().getPlugin("CoreProtect") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void setupCoreProtect() {
        CoreProtect coreProtect = (CoreProtect)Bukkit.getPluginManager().getPlugin("CoreProtect");
        if (coreProtect != null && coreProtect.isEnabled() && coreProtect.getAPI().isEnabled()) {
            this.coreProtectAPI = coreProtect.getAPI();
            TextHandler.get().logTranslated("plugin.separator", new Object[0]);
            TextHandler.get().logTranslated("coreprotect.integration.success", new Object[0]);
        } else {
            this.coreProtectAPI = null;
            TextHandler.get().logTranslated("plugin.separator", new Object[0]);
            TextHandler.get().logTranslated("coreprotect.integration.not_found_or_disabled", new Object[0]);
        }
    }

    public boolean isEnabled() {
        return this.coreProtectAPI != null && this.coreProtectAPI.isEnabled();
    }

    public void logLightPlacement(String playerName, List<Location> locations, Material material) {
        if (!this.isEnabled() || locations == null || locations.isEmpty()) {
            TextHandler.get().logTranslated("coreprotect.no_locations_provided", new Object[0]);
            return;
        }
        int successCount = this.processLocations(playerName, locations, material, true);
        if (successCount > 0) {
            TextHandler.get().logTranslated("coreprotect.placement.success", successCount, playerName);
        } else {
            TextHandler.get().logTranslated("coreprotect.placement.none", playerName);
        }
    }

    public void logRemoval(String playerName, List<Location> locations, Material forcedMaterial) {
        if (!this.isEnabled() || locations == null || locations.isEmpty()) {
            TextHandler.get().logTranslated("coreprotect.no_locations_provided", new Object[0]);
            return;
        }
        int successCount = this.processLocations(playerName, locations, forcedMaterial, false);
        if (successCount > 0) {
            TextHandler.get().logTranslated("coreprotect.removal.success", successCount, playerName);
        } else {
            TextHandler.get().logTranslated("coreprotect.removal.none", playerName);
        }
    }

    private int processLocations(String playerName, List<Location> locations, Material material, boolean isPlacement) {
        if (!this.isEnabled()) {
            return 0;
        }
        int successCount = 0;
        for (Location location : locations) {
            try {
                if (isPlacement) {
                    this.coreProtectAPI.logPlacement(playerName, location, material, null);
                } else {
                    this.coreProtectAPI.logRemoval(playerName, location, material, location.getBlock().getBlockData());
                }
                ++successCount;
            }
            catch (Exception e) {
                TextHandler.get().logTranslated(isPlacement ? "coreprotect.placement.error" : "coreprotect.removal.error", location, e.getMessage());
            }
        }
        return successCount;
    }
}

