/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.lights;

import com.soystargaze.lumen.Lumen;
import com.soystargaze.lumen.config.ConfigHandler;
import com.soystargaze.lumen.connections.CoreProtectHandler;
import com.soystargaze.lumen.database.LightRegistry;
import com.soystargaze.lumen.lights.integrations.ItemFAWEHandler;
import com.soystargaze.lumen.tasks.TaskManager;
import com.soystargaze.lumen.utils.AsyncExecutor;
import com.soystargaze.lumen.utils.DisplayUtil;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ItemLightsHandler {
    private final Lumen plugin;
    private final Executor executor = AsyncExecutor.getExecutor();
    private final CoreProtectHandler coreProtectHandler;
    private static int radius;
    private static int lightsPerTick;
    private static int tickInterval;

    public ItemLightsHandler(Lumen plugin) {
        this.plugin = plugin;
        this.coreProtectHandler = plugin.getCoreProtectHandler();
        ItemLightsHandler.reloadSettings();
    }

    public static void reloadSettings() {
        radius = ConfigHandler.getInt("settings.default_torch_radius", 20);
        lightsPerTick = ConfigHandler.getInt("settings.torch_lights_per_tick", 10);
        tickInterval = ConfigHandler.getInt("settings.torch_tick_interval", 10);
    }

    public void placeLights(Player player, Location center, int operationId, int lightLevel) {
        World world = center.getWorld();
        if (world == null) {
            TextHandler.get().sendAndLog(player, "light.error.no_world", new Object[0]);
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.calculateLightPositions(center, radius), this.executor).thenAcceptAsync(blocksToLight -> {
            if (blocksToLight.isEmpty()) {
                TextHandler.get().sendAndLog(player, "light.error.no_blocks_found", new Object[0]);
                return;
            }
            DisplayUtil.showBossBar(player, 0.0);
            DisplayUtil.showActionBar(player, 0.0);
            this.processBlocksAsync(player, (List<Location>)blocksToLight, lightLevel, lightsPerTick, tickInterval, operationId);
        }, runnable -> Bukkit.getScheduler().runTask((Plugin)this.plugin, runnable))).exceptionally(ex -> {
            TextHandler.get().logTranslated("light.error.calculating_positions", ex.getMessage());
            return null;
        });
    }

    private List<Location> calculateLightPositions(Location center, int radius) {
        LinkedList<Location> positions = new LinkedList<Location>();
        World world = center.getWorld();
        if (world == null) {
            return positions;
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Location location = center.clone().add((double)x, (double)y, (double)z);
                    if (!this.isValidLightPosition(location)) continue;
                    positions.add(location);
                }
            }
        }
        TextHandler.get().logTranslated("light.info.calculated_blocks", positions.size());
        return positions;
    }

    private boolean isValidLightPosition(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        Block block = location.getBlock();
        if (!block.getType().isAir()) {
            return false;
        }
        return this.isAdjacentToSolidBlock(location);
    }

    private boolean isAdjacentToSolidBlock(Location location) {
        int[][] offsets;
        for (int[] offset : offsets = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}}) {
            Location adjacent = location.clone().add((double)offset[0], (double)offset[1], (double)offset[2]);
            if (adjacent.getBlock().getType().isAir()) continue;
            return true;
        }
        return false;
    }

    private void processBlocksAsync(Player player, List<Location> blocks, int lightLevel, int lightsPerTick, int tickInterval, int operationId) {
        BukkitTask[] taskHolder;
        if (this.isFAWEAvailable()) {
            TextHandler.get().logTranslated("light.info.fawe_found", new Object[0]);
            ((CompletableFuture)CompletableFuture.runAsync(() -> ItemFAWEHandler.placeLightsWithFAWE(player, blocks, lightLevel, operationId), this.executor).thenRun(() -> {
                TextHandler.get().sendAndLog(player, "light.success.placed", operationId);
                DisplayUtil.hideBossBar(player);
                TaskManager.cancelTask(player.getUniqueId());
            })).exceptionally(ex -> {
                TextHandler.get().sendAndLog(player, "light.error.fawe_failed", ex.getMessage());
                return null;
            });
            return;
        }
        TextHandler.get().logTranslated("light.info.fawe_not_found", new Object[0]);
        LinkedList<Location> blockQueue = new LinkedList<Location>(blocks);
        taskHolder = new BukkitTask[]{Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!TaskManager.hasActiveTask(player.getUniqueId())) {
                TextHandler.get().logTranslated("light.info.operation_cancelled", operationId);
                DisplayUtil.hideBossBar(player);
                TaskManager.cancelTask(player.getUniqueId());
                taskHolder[0].cancel();
                return;
            }
            int processed = 0;
            int totalBlocks = blocks.size();
            LinkedList<Location> placedBlocks = new LinkedList<Location>();
            while (!blockQueue.isEmpty() && processed < lightsPerTick) {
                int validLightLevel;
                Location blockLocation = (Location)blockQueue.poll();
                if (blockLocation == null || !this.placeLight(blockLocation, validLightLevel = Math.max(0, Math.min(15, lightLevel)), operationId)) continue;
                placedBlocks.add(blockLocation);
                ++processed;
            }
            int completed = totalBlocks - blockQueue.size();
            double progress = (double)completed / (double)totalBlocks;
            DisplayUtil.showBossBar(player, progress);
            DisplayUtil.showActionBar(player, progress);
            if (blockQueue.isEmpty()) {
                if (this.coreProtectHandler != null && this.coreProtectHandler.isEnabled()) {
                    this.coreProtectHandler.logLightPlacement(player.getName(), placedBlocks, Material.LIGHT);
                }
                TextHandler.get().sendAndLog(player, "light.success.placed", operationId);
                DisplayUtil.hideBossBar(player);
                TaskManager.cancelTask(player.getUniqueId());
                taskHolder[0].cancel();
            }
        }, 0L, (long)tickInterval)};
        TaskManager.addTask(player.getUniqueId(), taskHolder[0]);
    }

    private boolean isFAWEAvailable() {
        return Bukkit.getPluginManager().isPluginEnabled("FastAsyncWorldEdit");
    }

    private boolean placeLight(Location location, int lightLevel, int operationId) {
        Block block = location.getBlock();
        if (!block.getType().isAir()) {
            return false;
        }
        block.setType(Material.LIGHT, false);
        if (block.getType() == Material.LIGHT) {
            try {
                Levelled lightData = (Levelled)block.getBlockData();
                lightData.setLevel(lightLevel);
                block.setBlockData((BlockData)lightData, false);
                LightRegistry.addBlockAsync(location, lightLevel, operationId);
                return true;
            }
            catch (ClassCastException e) {
                TextHandler.get().logTranslated("light.error.setting_level_torch", location, e.getMessage());
            }
        }
        return false;
    }

    public void removeLights(Player player, int operationId) {
        CompletableFuture.supplyAsync(() -> LightRegistry.getBlocksByOperationId(operationId), this.executor).thenAcceptAsync(blocksToRemove -> {
            if (blocksToRemove.isEmpty()) {
                TextHandler.get().sendAndLog(player, "light.error.no_lights_to_remove", operationId);
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                for (Location location : blocksToRemove) {
                    Block block = location.getBlock();
                    if (block.getType() != Material.LIGHT) continue;
                    block.setType(Material.AIR, false);
                }
                LightRegistry.removeBlocksByOperationId(operationId);
            });
            if (this.coreProtectHandler != null && this.coreProtectHandler.isEnabled()) {
                this.coreProtectHandler.logRemoval(player.getName(), (List<Location>)blocksToRemove, Material.LIGHT);
            }
        });
    }

    public void cancelOperation(Player player, int operationId) {
        if (TaskManager.hasActiveTask(player.getUniqueId())) {
            TaskManager.cancelTask(player.getUniqueId());
        }
        this.removeLights(player, operationId);
        DisplayUtil.hideBossBar(player);
        TextHandler.get().sendAndLog(player, "light.success.removed", operationId);
    }
}

