/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.lights;

import com.soystargaze.lumen.Lumen;
import com.soystargaze.lumen.config.ConfigHandler;
import com.soystargaze.lumen.connections.CoreProtectHandler;
import com.soystargaze.lumen.database.LightRegistry;
import com.soystargaze.lumen.lights.integrations.FAWEHandler;
import com.soystargaze.lumen.tasks.TaskManager;
import com.soystargaze.lumen.utils.AsyncExecutor;
import com.soystargaze.lumen.utils.BatchProcessor;
import com.soystargaze.lumen.utils.DisplayUtil;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class LightHandler {
    private final Lumen plugin;
    private final CoreProtectHandler coreProtectHandler;

    public LightHandler(Lumen plugin) {
        this.plugin = plugin;
        this.coreProtectHandler = plugin.getCoreProtectHandler();
    }

    public void placeLights(Player player, int areaBlocks, int lightLevel, boolean includeSkylight, int operationId) {
        Location center = player.getLocation();
        World world = center.getWorld();
        if (world == null) {
            TextHandler.get().sendAndLog(player, "light.error.no_world", new Object[0]);
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.calculateLightPositions(center, areaBlocks, includeSkylight), AsyncExecutor.getExecutor()).thenAccept(blocksToLight -> {
            if (blocksToLight.isEmpty()) {
                TextHandler.get().sendAndLog(player, "light.error.no_blocks_found", new Object[0]);
                return;
            }
            this.processBlocksAsync(player, (List<Location>)blocksToLight, lightLevel, operationId);
        })).exceptionally(ex -> {
            TextHandler.get().logTranslated("light.error.calculating_positions", ex.getMessage());
            return null;
        });
    }

    private List<Location> calculateLightPositions(Location center, int areaBlocks, boolean includeSkylight) {
        ArrayList<Location> positions = new ArrayList<Location>();
        World world = center.getWorld();
        if (world == null) {
            TextHandler.get().logTranslated("light.warning.no_world", new Object[0]);
            return positions;
        }
        for (int x = -areaBlocks; x <= areaBlocks; ++x) {
            for (int y = Math.max(center.getBlockY() - areaBlocks, world.getMinHeight()); y <= Math.min(center.getBlockY() + areaBlocks, world.getMaxHeight()); ++y) {
                for (int z = -areaBlocks; z <= areaBlocks; ++z) {
                    Location location = new Location(world, (double)(center.getBlockX() + x), (double)y, (double)(center.getBlockZ() + z));
                    if (!this.isValidLightPosition(location, center, areaBlocks, includeSkylight)) continue;
                    positions.add(location);
                }
            }
        }
        TextHandler.get().logTranslated("light.info.calculated_blocks", positions.size());
        return positions;
    }

    private boolean isValidLightPosition(Location location, Location center, int maxDistance, boolean includeSkylight) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        Block block = location.getBlock();
        if (!block.getType().isAir()) {
            return false;
        }
        if (location.getBlockX() < center.getBlockX() - maxDistance || location.getBlockX() > center.getBlockX() + maxDistance || location.getBlockY() < center.getBlockY() - maxDistance || location.getBlockY() > center.getBlockY() + maxDistance || location.getBlockZ() < center.getBlockZ() - maxDistance || location.getBlockZ() > center.getBlockZ() + maxDistance) {
            return false;
        }
        if (!this.isAdjacentToSolidBlock(location)) {
            return false;
        }
        if (includeSkylight) {
            return block.getLightFromSky() > 0 && (double)world.getHighestBlockYAt(location) <= location.getY();
        }
        return true;
    }

    private boolean isAdjacentToSolidBlock(Location location) {
        int[][] offsets;
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        for (int[] offset : offsets = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}}) {
            Location adjacent = location.clone().add((double)offset[0], (double)offset[1], (double)offset[2]);
            Block adjacentBlock = adjacent.getBlock();
            Material type = adjacentBlock.getType();
            if (type.isAir() && type != Material.WATER && type != Material.LAVA) continue;
            return true;
        }
        return false;
    }

    private void processBlocksAsync(Player player, List<Location> blocks, int lightLevel, int operationId) {
        if (this.isFAWEAvailable()) {
            TextHandler.get().logTranslated("light.info.fawe_found", new Object[0]);
            ((CompletableFuture)CompletableFuture.runAsync(() -> {
                try {
                    FAWEHandler.placeLightBlocks(blocks, lightLevel, player, this.coreProtectHandler);
                    LightRegistry.addBlocksAsync(blocks, lightLevel, operationId);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error during FAWE block placement: " + e.getMessage(), e);
                }
            }).thenRun(() -> {
                TextHandler.get().sendAndLog(player, "light.info.completed_operation", operationId);
                DisplayUtil.hideBossBar(player);
                TaskManager.cancelTask(player.getUniqueId());
            })).exceptionally(ex -> {
                TextHandler.get().sendAndLog(player, "light.error.fawe_failed", ex.getMessage());
                return null;
            });
            return;
        }
        TextHandler.get().logTranslated("light.info.fawe_not_found", new Object[0]);
        int maxBlocksPerTick = ConfigHandler.getInt("settings.command_lights_per_tick", 1000);
        LinkedList<Location> blockQueue = new LinkedList<Location>(blocks);
        ArrayList processedBlocks = new ArrayList();
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            int processedCount = 0;
            int totalBlocks = blocks.size();
            while (!blockQueue.isEmpty() && processedCount < maxBlocksPerTick) {
                Location blockLocation = (Location)blockQueue.poll();
                if (blockLocation == null) continue;
                boolean success = this.processSingleBlock(blockLocation, lightLevel, operationId);
                if (success) {
                    processedBlocks.add(blockLocation);
                }
                ++processedCount;
            }
            double progress = (double)(totalBlocks - blockQueue.size()) / (double)totalBlocks;
            DisplayUtil.showBossBar(player, progress);
            DisplayUtil.showActionBar(player, progress);
            if (blockQueue.isEmpty()) {
                if (!processedBlocks.isEmpty() && this.coreProtectHandler != null && this.coreProtectHandler.isEnabled()) {
                    this.coreProtectHandler.logLightPlacement(player.getName(), processedBlocks, Material.LIGHT);
                    TextHandler.get().logTranslated("light.info.blocks_registered", processedBlocks.size());
                } else {
                    TextHandler.get().logTranslated("light.warning.no_blocks_registered", operationId);
                }
                TextHandler.get().sendAndLog(player, "light.info.completed_operation", operationId);
                DisplayUtil.hideBossBar(player);
                TaskManager.cancelTask(player.getUniqueId());
            }
        }, 0L, 1L);
        TaskManager.addTask(player.getUniqueId(), task);
    }

    private boolean isFAWEAvailable() {
        return Bukkit.getPluginManager().isPluginEnabled("FastAsyncWorldEdit");
    }

    private boolean processSingleBlock(Location blockLocation, int lightLevel, int operationId) {
        Block block = blockLocation.getBlock();
        block.setType(Material.LIGHT, false);
        if (block.getType() == Material.LIGHT) {
            try {
                Levelled lightData = (Levelled)block.getBlockData();
                lightData.setLevel(lightLevel);
                block.setBlockData((BlockData)lightData, false);
                BatchProcessor.addBlockToBatch(blockLocation, lightLevel, operationId);
                return true;
            }
            catch (ClassCastException e) {
                TextHandler.get().logTranslated("light.error.setting_level", blockLocation, e.getMessage());
            }
        }
        return false;
    }
}

