/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.listeners;

import com.soystargaze.lumen.utils.LumenConstants;
import com.soystargaze.lumen.utils.text.TextHandler;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class CraftPermissionListener
implements Listener {
    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        NamespacedKey key;
        HumanEntity humanEntity = event.getView().getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (event.getRecipe() == null) {
            return;
        }
        ItemStack result = event.getRecipe().getResult();
        if (result.getType().isAir() || !result.hasItemMeta()) {
            return;
        }
        ItemMeta meta = result.getItemMeta();
        assert (meta != null);
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.has(key = LumenConstants.getLumenIdKey(), PersistentDataType.STRING)) {
            String itemId = (String)container.get(key, PersistentDataType.STRING);
            if ("torch".equals(itemId) && !player.hasPermission("lumen.craft.torch")) {
                event.getInventory().setResult(null);
                TextHandler.get().sendMessage(player, "items.torch.no-permission", new Object[0]);
            } else if ("guard".equals(itemId) && !player.hasPermission("lumen.craft.guard")) {
                event.getInventory().setResult(null);
                TextHandler.get().sendMessage(player, "items.guard.no-permission", new Object[0]);
            }
        }
    }
}

