/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.lumen.listeners;

import com.soystargaze.lumen.config.ConfigHandler;
import com.soystargaze.lumen.database.LightRegistry;
import com.soystargaze.lumen.items.LumenItems;
import com.soystargaze.lumen.lights.ItemLightsHandler;
import com.soystargaze.lumen.utils.ItemEffectUtil;
import com.soystargaze.lumen.utils.LumenConstants;
import com.soystargaze.lumen.utils.text.TextHandler;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TorchListener
implements Listener {
    private final Plugin plugin;
    private final ItemLightsHandler lightsHandler;
    private final LumenItems lumenItems;
    private final NamespacedKey lumenIdKey;

    public TorchListener(Plugin plugin, ItemLightsHandler lightsHandler, LumenItems lumenItems) {
        this.plugin = plugin;
        this.lightsHandler = lightsHandler;
        this.lumenItems = lumenItems;
        this.lumenIdKey = LumenConstants.getLumenIdKey();
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        String id;
        PersistentDataContainer itemContainer;
        ItemStack itemInHand = event.getItemInHand();
        if (itemInHand.getItemMeta() != null && (itemContainer = itemInHand.getItemMeta().getPersistentDataContainer()).has(this.lumenIdKey, PersistentDataType.STRING) && "torch".equals(id = (String)itemContainer.get(this.lumenIdKey, PersistentDataType.STRING))) {
            Block placedBlock = event.getBlock();
            Player player = event.getPlayer();
            Location placedLocation = placedBlock.getLocation();
            int incrementalId = LightRegistry.registerOperation(UUID.randomUUID(), "Lumen Torch placed at " + String.valueOf(placedLocation));
            NamespacedKey lightLevelKey = new NamespacedKey(this.plugin, "custom_light_level");
            int lightLevel = itemContainer.has(lightLevelKey, PersistentDataType.INTEGER) ? Objects.requireNonNullElse((Integer)itemContainer.get(lightLevelKey, PersistentDataType.INTEGER), 15) : ConfigHandler.getInt("settings.torch_light_level", 15);
            BlockState blockState = placedBlock.getState();
            if (blockState instanceof TileState) {
                TileState tileState = (TileState)blockState;
                PersistentDataContainer container = tileState.getPersistentDataContainer();
                this.transferPersistentData(itemContainer, container);
                container.set(new NamespacedKey(this.plugin, "operation_id"), PersistentDataType.INTEGER, (Object)incrementalId);
                tileState.update();
            }
            this.lightsHandler.placeLights(player, placedLocation, incrementalId, lightLevel);
            ItemEffectUtil.playEffect(placedLocation, "torch");
            TextHandler.get().sendAndLog(player, "torch.light_placed", placedLocation, incrementalId);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        String id;
        TileState tileState;
        PersistentDataContainer blockContainer;
        Block brokenBlock = event.getBlock();
        Player player = event.getPlayer();
        BlockState blockState = brokenBlock.getState();
        if (blockState instanceof TileState && (blockContainer = (tileState = (TileState)blockState).getPersistentDataContainer()).has(this.lumenIdKey, PersistentDataType.STRING) && "torch".equals(id = (String)blockContainer.get(this.lumenIdKey, PersistentDataType.STRING))) {
            try {
                Integer incrementalId;
                NamespacedKey operationKey = new NamespacedKey(this.plugin, "operation_id");
                if (blockContainer.has(operationKey, PersistentDataType.INTEGER) && (incrementalId = (Integer)blockContainer.get(operationKey, PersistentDataType.INTEGER)) != null) {
                    this.lightsHandler.cancelOperation(player, incrementalId);
                    this.lightsHandler.removeLights(player, incrementalId);
                    ItemStack customItem = this.lumenItems.getLumenItem(id);
                    if (customItem != null) {
                        brokenBlock.getWorld().dropItemNaturally(brokenBlock.getLocation(), customItem.clone());
                        event.setDropItems(false);
                        TextHandler.get().sendAndLog(player, "torch.light_broken", incrementalId);
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe(String.format("Error handling Lumen Torch removal for player %s at %s: %s", player.getName(), brokenBlock.getLocation(), e.getMessage()));
            }
        }
    }

    private void transferPersistentData(PersistentDataContainer source, PersistentDataContainer target) {
        for (NamespacedKey key : source.getKeys()) {
            if (!source.has(key, PersistentDataType.STRING)) continue;
            target.set(key, PersistentDataType.STRING, (Object)Objects.requireNonNull((String)source.get(key, PersistentDataType.STRING)));
        }
    }

    @EventHandler
    public void onPlayerRightClickAir(PlayerInteractEvent event) {
        PersistentDataContainer container;
        if (event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        final Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType() == Material.PLAYER_HEAD && itemInHand.getItemMeta() != null && (container = itemInHand.getItemMeta().getPersistentDataContainer()).has(this.lumenIdKey, PersistentDataType.STRING) && "torch".equals(container.get(this.lumenIdKey, PersistentDataType.STRING))) {
            TextHandler.get().sendMessage(player, "torch.light_level_prompt", new Object[0]);
            this.plugin.getServer().getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onChat(AsyncPlayerChatEvent chatEvent) {
                    if (!chatEvent.getPlayer().equals((Object)player)) {
                        return;
                    }
                    chatEvent.setCancelled(true);
                    String message = chatEvent.getMessage();
                    try {
                        int lightLevel = Integer.parseInt(message);
                        if (lightLevel < 0 || lightLevel > 15) {
                            TextHandler.get().sendMessage(player, "torch.error.invalid_light_level", new Object[0]);
                            return;
                        }
                        ItemStack currentItem = player.getInventory().getItemInMainHand();
                        if (currentItem.getType() != Material.PLAYER_HEAD || currentItem.getItemMeta() == null) {
                            TextHandler.get().sendMessage(player, "torch.error.no_torch_in_hand", new Object[0]);
                            return;
                        }
                        ItemMeta meta = currentItem.getItemMeta();
                        PersistentDataContainer metaContainer = meta.getPersistentDataContainer();
                        metaContainer.set(new NamespacedKey(TorchListener.this.plugin, "custom_light_level"), PersistentDataType.INTEGER, (Object)lightLevel);
                        currentItem.setItemMeta(meta);
                        TextHandler.get().sendAndLog(player, "torch.light_level_set", lightLevel);
                    }
                    catch (NumberFormatException e) {
                        TextHandler.get().sendAndLog(player, "torch.error.invalid_light_level", new Object[0]);
                    }
                    AsyncPlayerChatEvent.getHandlerList().unregister((Listener)this);
                }
            }, this.plugin);
        }
    }
}

